/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.AndFileFilter;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.EqualsFilenameFilter;
import com.mucommander.commons.file.filter.StartsWithFilenameFilter;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.job.CombineFilesJob;
import com.mucommander.job.TransferFileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.file.PathFieldContent;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.dialog.file.TransferDestinationDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineFilesDialog
extends TransferDestinationDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombineFilesDialog.class);
    private AbstractFile destFolder;

    public CombineFilesDialog(MainFrame mainFrame, FileSet files, AbstractFile destFolder) {
        super(mainFrame, files, ActionProperties.getActionLabel("CombineFiles"), Translator.get("copy_dialog.destination", new String[0]), Translator.get("combine", new String[0]), Translator.get("combine_files_dialog.error_title", new String[0]), true);
        this.destFolder = destFolder;
    }

    private void searchParts(AbstractFile part1) {
        int firstIndex;
        AbstractFile parent = part1.getParent();
        if (parent == null) {
            return;
        }
        String ext = part1.getExtension();
        try {
            firstIndex = Integer.parseInt(ext);
        }
        catch (NumberFormatException e) {
            return;
        }
        AndFileFilter filter = new AndFileFilter(new StartsWithFilenameFilter(part1.getNameWithoutExtension(), false), new AttributeFileFilter(1), new EqualsFilenameFilter(part1.getName(), false, true));
        try {
            AbstractFile[] otherParts;
            for (AbstractFile otherPart : otherParts = parent.ls(filter)) {
                String ext2 = otherPart.getExtension();
                try {
                    int partIdx = Integer.parseInt(ext2);
                    if (partIdx <= firstIndex) continue;
                    this.files.add(otherPart);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug("Caught exception", e);
        }
        this.setFiles(this.files);
    }

    protected boolean isValidDestination(PathUtils.ResolvedDestination resolvedDest, String destPath) {
        if (resolvedDest == null) {
            this.showErrorDialog(Translator.get("invalid_path", destPath), this.errorDialogTitle);
            return false;
        }
        return true;
    }

    protected PathFieldContent computeInitialPath(FileSet files) {
        String path = this.destFolder.getAbsolutePath(true) + ((AbstractFile)files.elementAt(0)).getNameWithoutExtension();
        if (files.size() == 1) {
            this.searchParts((AbstractFile)files.elementAt(0));
        }
        return new PathFieldContent(path);
    }

    protected TransferFileJob createTransferFileJob(ProgressDialog progressDialog, PathUtils.ResolvedDestination resolvedDest, int defaultFileExistsAction) {
        return new CombineFilesJob(progressDialog, this.mainFrame, this.files, resolvedDest.getDestinationFile(), defaultFileExistsAction);
    }

    protected String getProgressDialogTitle() {
        return Translator.get("progress_dialog.processing_files", new String[0]);
    }
}

