/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.ChangeFileAttributesJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.file.JobDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.AsyncPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.SizeConstrainedDocument;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class ChangePermissionsDialog
extends JobDialog
implements ActionListener,
ItemListener,
DocumentListener {
    private JCheckBox[][] permCheckBoxes;
    private JTextField octalPermTextField;
    private JCheckBox recurseDirCheckBox;
    private boolean ignoreItemEvent;
    private boolean ignoreDocumentEvent;
    private JButton okButton;
    private JButton cancelButton;

    public ChangePermissionsDialog(MainFrame mainFrame, FileSet files) {
        super(mainFrame, ActionProperties.getActionLabel("ChangePermissions"), files);
        YBoxPanel mainPanel = new YBoxPanel();
        mainPanel.add(new JLabel(ActionProperties.getActionLabel("ChangePermissions") + " :"));
        mainPanel.addSpace(10);
        JPanel gridPanel = new JPanel(new GridLayout(4, 4));
        this.permCheckBoxes = new JCheckBox[5][5];
        AbstractFile firstFile = (AbstractFile)files.elementAt(0);
        int permSetMask = firstFile.getChangeablePermissions().getIntValue();
        boolean canSetPermission = permSetMask != 0;
        int defaultPerms = firstFile.getPermissions().getIntValue();
        gridPanel.add(new JLabel());
        gridPanel.add(new JLabel(Translator.get("permissions.read", new String[0])));
        gridPanel.add(new JLabel(Translator.get("permissions.write", new String[0])));
        gridPanel.add(new JLabel(Translator.get("permissions.executable", new String[0])));
        for (int a = 2; a >= 0; --a) {
            gridPanel.add(new JLabel(Translator.get(a == 2 ? "permissions.user" : (a == 1 ? "permissions.group" : "permissions.other"), new String[0])));
            for (int p = 4; p >= 1; p >>= 1) {
                JCheckBox permCheckBox = new JCheckBox();
                permCheckBox.setSelected((defaultPerms & p << a * 3) != 0);
                if ((permSetMask & p << a * 3) == 0) {
                    permCheckBox.setEnabled(false);
                } else {
                    permCheckBox.addItemListener(this);
                }
                gridPanel.add(permCheckBox);
                this.permCheckBoxes[a][p] = permCheckBox;
            }
        }
        mainPanel.add(gridPanel);
        this.octalPermTextField = new JTextField(3);
        SizeConstrainedDocument doc = new SizeConstrainedDocument(3){

            public void insertString(int offset, String str, AttributeSet attributeSet) throws BadLocationException {
                int strLen = str.length();
                for (int i = 0; i < strLen; ++i) {
                    char c = str.charAt(i);
                    if (c >= '0' && c <= '7') continue;
                    return;
                }
                super.insertString(offset, str, attributeSet);
            }
        };
        this.octalPermTextField.setDocument(doc);
        this.updateOctalPermTextField();
        if (canSetPermission) {
            doc.addDocumentListener(this);
        } else {
            this.octalPermTextField.setEnabled(false);
        }
        mainPanel.addSpace(10);
        JPanel tempPanel = new JPanel(new FlowLayout(0));
        tempPanel.add(new JLabel(Translator.get("permissions.octal_notation", new String[0])));
        tempPanel.add(this.octalPermTextField);
        mainPanel.add(tempPanel);
        mainPanel.addSpace(15);
        this.recurseDirCheckBox = new JCheckBox(Translator.get("recurse_directories", new String[0]));
        this.recurseDirCheckBox.setEnabled(canSetPermission && (files.size() > 1 || ((AbstractFile)files.elementAt(0)).isDirectory()));
        mainPanel.add(this.recurseDirCheckBox);
        AsyncPanel fileDetailsPanel = this.createFileDetailsPanel();
        this.okButton = new JButton(Translator.get("change", new String[0]));
        this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
        mainPanel.add(this.createButtonsPanel(this.createFileDetailsButton(fileDetailsPanel), DialogToolkit.createOKCancelPanel(this.okButton, this.cancelButton, this.getRootPane(), this)));
        mainPanel.add(fileDetailsPanel);
        this.getContentPane().add((Component)mainPanel, "North");
        if (!canSetPermission) {
            this.okButton.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(canSetPermission ? this.okButton : this.cancelButton);
        this.setResizable(false);
    }

    private int getPermInt() {
        int perms = 0;
        for (int a = 2; a >= 0; --a) {
            for (int p = 4; p >= 1; p >>= 1) {
                JCheckBox permCheckBox = this.permCheckBoxes[a][p];
                if (!permCheckBox.isSelected()) continue;
                perms |= p << a * 3;
            }
        }
        return perms;
    }

    private void updateOctalPermTextField() {
        int len;
        String octalStr = Integer.toOctalString(this.getPermInt());
        for (int i = len = octalStr.length(); i < 3; ++i) {
            octalStr = "0" + octalStr;
        }
        this.octalPermTextField.setText(octalStr);
    }

    private void updatePermCheckBoxes() {
        String octalStr = this.octalPermTextField.getText();
        int perms = octalStr.equals("") ? 0 : Integer.parseInt(octalStr, 8);
        for (int a = 2; a >= 0; --a) {
            for (int p = 4; p >= 1; p >>= 1) {
                JCheckBox permCheckBox = this.permCheckBoxes[a][p];
                permCheckBox.setSelected((perms & p << a * 3) != 0);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.dispose();
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("progress_dialog.processing_files", new String[0]));
            ChangeFileAttributesJob job = new ChangeFileAttributesJob(progressDialog, this.mainFrame, this.files, this.getPermInt(), this.recurseDirCheckBox.isSelected());
            progressDialog.start(job);
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.ignoreItemEvent) {
            return;
        }
        this.ignoreDocumentEvent = true;
        this.updateOctalPermTextField();
        this.ignoreDocumentEvent = false;
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.ignoreDocumentEvent) {
            return;
        }
        this.ignoreItemEvent = true;
        this.updatePermCheckBoxes();
        this.ignoreItemEvent = false;
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.ignoreDocumentEvent) {
            return;
        }
        this.ignoreItemEvent = true;
        this.updatePermCheckBoxes();
        this.ignoreItemEvent = false;
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.ignoreDocumentEvent) {
            return;
        }
        this.ignoreItemEvent = true;
        this.updatePermCheckBoxes();
        this.ignoreItemEvent = false;
    }
}

