/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BatchRenameSelectRange
extends FocusDialog
implements ActionListener {
    private JTextField edtRange = new JTextField();
    private JButton btnCancel;
    private JButton btnOK;
    private String range = null;

    public BatchRenameSelectRange(Dialog owner, String filename) {
        super(owner, Translator.get("batch_rename_dialog.range", new String[0]), (Component)owner);
        ReadOnlyDocument doc = new ReadOnlyDocument();
        this.edtRange.setDocument(doc);
        this.edtRange.setText(filename);
        this.edtRange.setColumns(filename.length() + 5);
        this.edtRange.setSelectionStart(0);
        this.edtRange.setSelectionEnd(filename.length());
        doc.setReadOnly(true);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.edtRange, "Center");
        this.btnOK = new JButton(Translator.get("ok", new String[0]));
        this.btnCancel = new JButton(Translator.get("cancel", new String[0]));
        content.add((Component)DialogToolkit.createOKCancelPanel(this.btnOK, this.btnCancel, this.getRootPane(), this), "South");
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnCancel) {
            this.dispose();
        } else if (source == this.btnOK) {
            this.range = "[N" + Integer.toString(this.edtRange.getSelectionStart() + 1);
            if (this.edtRange.getSelectionEnd() > 0 && this.edtRange.getSelectionEnd() > this.edtRange.getSelectionStart() + 1) {
                this.range = this.range + "-" + Integer.toString(this.edtRange.getSelectionEnd());
            }
            this.range = this.range + "]";
            this.dispose();
        }
    }

    public String getRange() {
        return this.range;
    }

    private static class ReadOnlyDocument
    extends PlainDocument {
        private boolean readOnly = false;

        private ReadOnlyDocument() {
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (!this.readOnly) {
                super.insertString(offs, str, a);
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (!this.readOnly) {
                super.remove(offs, len);
            }
        }
    }
}

