/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.commons.util.StringUtils;
import com.mucommander.job.BatchRenameJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.dialog.file.BatchRenameConfirmationDialog;
import com.mucommander.ui.dialog.file.BatchRenameSelectRange;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.main.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRenameDialog
extends FocusDialog
implements ActionListener,
DocumentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchRenameDialog.class);
    private MainFrame mainFrame;
    private JTextField edtFileNameMask;
    private JTable tblNames;
    private JButton btnRename;
    private JButton btnClose;
    private JTextField edtSearchFor;
    private JTextField edtReplaceWith;
    private JTextField edtCounterStart;
    private JTextField edtCounterStep;
    private JComboBox cbCounterDigits;
    private JComboBox cbCase;
    private RenameTableModel tableModel;
    private AbstractAction actRemove;
    private JButton btnName;
    private JButton btnNameRange;
    private JButton btnExtension;
    private JButton btnCounter;
    private JLabel lblDuplicates;
    private TableColumn colBlock;
    private FileSet files;
    private HashMap<String, AbstractFile> oldNames = new HashMap();
    private List<String> newNames = new ArrayList<String>();
    private List<Boolean> blockNames = new ArrayList<Boolean>();
    private List<AbstractToken> tokens = new ArrayList<AbstractToken>();

    public BatchRenameDialog(MainFrame mainFrame, FileSet files) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("BatchRename"), null);
        this.mainFrame = mainFrame;
        this.files = files;
        for (AbstractFile f : files) {
            this.blockNames.add(Boolean.FALSE);
            this.newNames.add("");
            this.oldNames.put(PathUtils.removeTrailingSeparator(f.getAbsolutePath()), f);
        }
        this.initialize();
        this.generateNewNames();
    }

    private void initialize() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.getPnlTop(), "North");
        content.add((Component)new JScrollPane(this.getTblNames()), "Center");
        content.add((Component)this.getPnlButtons(), "South");
        this.getRootPane().setDefaultButton(this.btnRename);
    }

    private JPanel getPnlButtons() {
        JPanel pnlButtons = new JPanel(new BorderLayout());
        pnlButtons.add((Component)new JButton(this.getActRemove()), "West");
        XBoxPanel pnlButtonsRight = new XBoxPanel();
        this.lblDuplicates = new JLabel(Translator.get("batch_rename_dialog.duplicate_names", new String[0]));
        this.lblDuplicates.setForeground(Color.red);
        this.lblDuplicates.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 15));
        pnlButtonsRight.add(this.lblDuplicates);
        this.btnRename = new JButton(Translator.get("rename", new String[0]));
        this.btnRename.addActionListener(this);
        pnlButtonsRight.add(this.btnRename);
        this.btnClose = new JButton(Translator.get("cancel", new String[0]));
        this.btnClose.addActionListener(this);
        pnlButtonsRight.add(this.btnClose);
        pnlButtons.add((Component)pnlButtonsRight, "East");
        return pnlButtons;
    }

    private JTable getTblNames() {
        if (this.tblNames == null) {
            this.tableModel = new RenameTableModel();
            this.tblNames = new JTable(this.tableModel);
            this.tblNames.getActionMap().put("del", this.getActRemove());
            this.tblNames.getInputMap().put((KeyStroke)this.getActRemove().getValue("AcceleratorKey"), "del");
            this.tblNames.getActionMap().put("tab", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    BatchRenameDialog.this.tblNames.transferFocus();
                }
            });
            this.tblNames.getInputMap().put(KeyStroke.getKeyStroke(9, 0, false), "tab");
            this.tblNames.getActionMap().put("shift tab", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    BatchRenameDialog.this.tblNames.transferFocusBackward();
                }
            });
            this.tblNames.getInputMap().put(KeyStroke.getKeyStroke(9, 64, false), "shift tab");
            this.tblNames.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new JTextField()));
            this.colBlock = this.tblNames.getColumnModel().getColumn(2);
            this.colBlock.setMaxWidth(60);
            this.tblNames.removeColumn(this.colBlock);
        }
        return this.tblNames;
    }

    public Action getActRemove() {
        if (this.actRemove == null) {
            this.actRemove = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    BatchRenameDialog.this.removeSelectedFiles();
                }
            };
            this.actRemove.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.actRemove.putValue("Name", Translator.get("remove", new String[0]));
        }
        return this.actRemove;
    }

    private JPanel getPnlTop() {
        this.edtFileNameMask = new JTextField("[N].[E]");
        this.edtFileNameMask.setColumns(20);
        this.edtFileNameMask.getDocument().addDocumentListener(this);
        this.edtFileNameMask.setToolTipText(this.getPatternHelp());
        this.edtSearchFor = new JTextField();
        this.edtSearchFor.setColumns(20);
        this.edtSearchFor.getDocument().addDocumentListener(this);
        this.edtReplaceWith = new JTextField();
        this.edtReplaceWith.setColumns(20);
        this.edtReplaceWith.getDocument().addDocumentListener(this);
        Vector<String> ulcase = new Vector<String>();
        ulcase.add(Translator.get("batch_rename_dialog.no_change", new String[0]));
        ulcase.add(Translator.get("batch_rename_dialog.lower_case", new String[0]));
        ulcase.add(Translator.get("batch_rename_dialog.upper_case", new String[0]));
        ulcase.add(Translator.get("batch_rename_dialog.first_upper", new String[0]));
        ulcase.add(Translator.get("batch_rename_dialog.word", new String[0]));
        this.cbCase = new JComboBox(ulcase);
        this.cbCase.addActionListener(this);
        this.edtCounterStart = new JTextField("1");
        this.edtCounterStart.getDocument().addDocumentListener(this);
        this.edtCounterStart.setColumns(2);
        this.edtCounterStep = new JTextField("1");
        this.edtCounterStep.getDocument().addDocumentListener(this);
        this.edtCounterStep.setColumns(2);
        Vector<String> digits = new Vector<String>();
        String zeros = "0000";
        for (int i = 1; i <= 5; ++i) {
            digits.add(zeros.substring(0, i - 1) + "1");
        }
        this.cbCounterDigits = new JComboBox(digits);
        this.cbCounterDigits.addActionListener(this);
        XBoxPanel pnlTop = new XBoxPanel();
        YBoxPanel pnl1 = new YBoxPanel();
        pnl1.setBorder(BorderFactory.createTitledBorder(Translator.get("batch_rename_dialog.mask", new String[0])));
        pnl1.add(this.edtFileNameMask);
        JPanel pnl1Btns = new JPanel(new GridLayout(3, 2));
        this.btnName = new JButton("[N] - " + Translator.get("name", new String[0]));
        this.btnName.addActionListener(this);
        this.btnName.setHorizontalAlignment(2);
        pnl1Btns.add(this.btnName);
        this.btnExtension = new JButton("[E] - " + Translator.get("extension", new String[0]));
        this.btnExtension.addActionListener(this);
        this.btnExtension.setHorizontalAlignment(2);
        pnl1Btns.add(this.btnExtension);
        this.btnNameRange = new JButton("[N#-#] - " + Translator.get("batch_rename_dialog.range", new String[0]));
        this.btnNameRange.addActionListener(this);
        this.btnNameRange.setHorizontalAlignment(2);
        pnl1Btns.add(this.btnNameRange);
        this.btnCounter = new JButton("[C] - " + Translator.get("batch_rename_dialog.counter", new String[0]));
        this.btnCounter.addActionListener(this);
        this.btnCounter.setHorizontalAlignment(2);
        pnl1Btns.add(this.btnCounter);
        pnl1.add(pnl1Btns);
        pnl1.add(new JPanel());
        pnlTop.add(pnl1);
        XAlignedComponentPanel pnl2 = new XAlignedComponentPanel(5);
        pnl2.setBorder(BorderFactory.createTitledBorder(Translator.get("batch_rename_dialog.search_replace", new String[0])));
        pnl2.addRow(Translator.get("batch_rename_dialog.search_for", new String[0]), (JComponent)this.edtSearchFor, 5);
        pnl2.addRow(Translator.get("batch_rename_dialog.replace_with", new String[0]), (JComponent)this.edtReplaceWith, 5);
        pnl2.addRow(Translator.get("batch_rename_dialog.upper_lower_case", new String[0]), (JComponent)this.cbCase, 5);
        pnlTop.add(pnl2);
        XAlignedComponentPanel pnl3 = new XAlignedComponentPanel(5);
        pnl3.setBorder(BorderFactory.createTitledBorder(Translator.get("batch_rename_dialog.counter", new String[0]) + " [C]"));
        pnl3.addRow(Translator.get("batch_rename_dialog.start_at", new String[0]), (JComponent)this.edtCounterStart, 5);
        pnl3.addRow(Translator.get("batch_rename_dialog.step_by", new String[0]), (JComponent)this.edtCounterStep, 5);
        pnl3.addRow(Translator.get("batch_rename_dialog.format", new String[0]), (JComponent)this.cbCounterDigits, 5);
        pnlTop.add(pnl3);
        return pnlTop;
    }

    private String getPatternHelp() {
        return "<html>[N] - the whole name<br>[N2,3] - 3 characters starting from the 2nd character of the name<br>[N2-5] - characters 2 to 5<br>[N2-] - all characters starting from the 2nd character<br>[N-3,2] - two characters starting at 3rd character from the end of the name<br>[N2--2] - characters from the 2nd to the 2nd-last character<br>[C] - inserts a counter<br>[C10,2,3] - inserts a counter starting at 10, steps by 2, uses 3 digits<br>[YMD] - inserts a year, month and day when the file was last modified";
    }

    private void removeSelectedFiles() {
        int[] sel = this.tblNames.getSelectedRows();
        for (int i = sel.length - 1; i >= 0; --i) {
            this.files.remove(sel[i]);
            this.newNames.remove(sel[i]);
            this.blockNames.remove(sel[i]);
            this.tableModel.fireTableRowsDeleted(sel[i], sel[i]);
        }
        if (this.files.size() == 0) {
            this.dispose();
        }
    }

    private void checkForDuplicates() {
        boolean duplicates = false;
        boolean oldNamesConflict = false;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.newNames.size(); ++i) {
            String newName = this.newNames.get(i);
            AbstractFile file = (AbstractFile)this.files.get(i);
            AbstractFile parent = file.getParent();
            if (parent != null) {
                newName = parent.getAbsolutePath(true) + newName;
            }
            if (names.contains(newName)) {
                duplicates = true;
                break;
            }
            AbstractFile oldFile = this.oldNames.get(newName);
            if (oldFile != null && oldFile != file) {
                oldNamesConflict = true;
                break;
            }
            names.add(newName);
        }
        if (duplicates) {
            this.lblDuplicates.setText(Translator.get("batch_rename_dialog.duplicate_names", new String[0]));
        }
        if (oldNamesConflict) {
            this.lblDuplicates.setText(Translator.get("batch_rename_dialog.names_conflict", new String[0]));
        }
        this.lblDuplicates.setVisible(duplicates || oldNamesConflict);
        this.btnRename.setEnabled(!duplicates && !oldNamesConflict);
    }

    private String generateNewName(AbstractFile file) {
        String newName = this.applyPattern(file);
        if (this.edtSearchFor.getText().length() > 0) {
            newName = newName.replace(this.edtSearchFor.getText(), this.edtReplaceWith.getText());
        }
        if (newName.endsWith(".")) {
            newName = newName.substring(0, newName.length() - 1);
        }
        newName = this.changeCase(newName, this.cbCase.getSelectedIndex());
        return newName;
    }

    private void generateNewNames() {
        this.compilePattern(this.edtFileNameMask.getText());
        for (int i = 0; i < this.files.size(); ++i) {
            if (!Boolean.FALSE.equals(this.blockNames.get(i))) continue;
            AbstractFile file = (AbstractFile)this.files.get(i);
            String newName = this.generateNewName(file);
            this.newNames.set(i, newName);
        }
        this.checkForDuplicates();
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, 0, this.newNames.size(), 1, 0));
    }

    private void compilePattern(String pattern) {
        this.tokens.clear();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '[') {
                int tokenEnd = pattern.indexOf(93, i);
                if (tokenEnd == -1) {
                    this.tokens.add(new CopyChar(pattern.substring(i)));
                    break;
                }
                String strToken = pattern.substring(i + 1, tokenEnd);
                if (strToken.length() > 0) {
                    AbstractToken t;
                    c = strToken.charAt(0);
                    switch (c) {
                        case 'N': {
                            t = new NameToken(strToken);
                            break;
                        }
                        case 'E': {
                            t = new ExtToken(strToken);
                            break;
                        }
                        case 'C': {
                            int start = StringUtils.parseIntDef(this.edtCounterStart.getText(), 0);
                            int step = StringUtils.parseIntDef(this.edtCounterStep.getText(), 0);
                            int digits = this.cbCounterDigits.getSelectedIndex() + 1;
                            t = new CounterToken(strToken, start, step, digits);
                            break;
                        }
                        case 'P': {
                            t = new ParentDirToken(strToken);
                            break;
                        }
                        case 'D': 
                        case 'M': 
                        case 'Y': 
                        case 'h': 
                        case 'm': 
                        case 's': {
                            t = new DateToken(strToken);
                            break;
                        }
                        case '[': {
                            t = new CopyChar("[");
                            break;
                        }
                        default: {
                            t = new CopyChar("[" + strToken + "]");
                        }
                    }
                    t.parse();
                    this.tokens.add(t);
                }
                i = tokenEnd;
                continue;
            }
            this.tokens.add(new CopyChar(Character.toString(c)));
        }
    }

    private String changeCase(String oldName, int newCase) {
        String newName = "";
        switch (newCase) {
            case 0: {
                newName = oldName;
                break;
            }
            case 1: {
                newName = oldName.toLowerCase();
                break;
            }
            case 2: {
                newName = oldName.toUpperCase();
                break;
            }
            case 3: {
                newName = oldName.substring(0, 1).toUpperCase() + oldName.substring(1).toLowerCase();
                break;
            }
            case 4: {
                boolean afterSpace = true;
                StringBuilder newNameCase = new StringBuilder();
                for (int i = 0; i < oldName.length(); ++i) {
                    if (oldName.charAt(i) == ' ') {
                        newNameCase.append(' ');
                        afterSpace = true;
                        continue;
                    }
                    if (afterSpace) {
                        newNameCase.append(Character.toUpperCase(oldName.charAt(i)));
                        afterSpace = false;
                        continue;
                    }
                    newNameCase.append(oldName.charAt(i));
                }
                newName = newNameCase.toString();
            }
        }
        return newName;
    }

    private String applyPattern(AbstractFile file) {
        StringBuilder filename = new StringBuilder();
        for (AbstractToken token : this.tokens) {
            filename.append(token.apply(file));
        }
        return filename.toString();
    }

    private int removeUnchangedFiles(boolean countOnly) {
        Iterator fi = this.files.iterator();
        Iterator<String> ni = this.newNames.iterator();
        int changed = 0;
        while (fi.hasNext()) {
            AbstractFile file = (AbstractFile)fi.next();
            String nn = ni.next();
            if (file.getName().equals(nn)) {
                if (countOnly) continue;
                fi.remove();
                ni.remove();
                continue;
            }
            ++changed;
        }
        return changed;
    }

    private void doRename() {
        this.removeUnchangedFiles(false);
        if (this.files.size() > 0) {
            ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("progress_dialog.processing_files", new String[0]));
            BatchRenameJob job = new BatchRenameJob(progressDialog, this.mainFrame, this.files, this.newNames);
            progressDialog.start(job);
        }
    }

    private void insertPattern(String string) {
        int n = this.edtFileNameMask.getSelectionStart();
        try {
            int n2 = this.edtFileNameMask.getSelectionEnd() - this.edtFileNameMask.getSelectionStart();
            if (n2 > 0) {
                this.edtFileNameMask.getDocument().remove(this.edtFileNameMask.getSelectionStart(), n2);
            }
            this.edtFileNameMask.getDocument().insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.debug("Caught exception", badLocationException);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnClose) {
            this.dispose();
        } else if (object == this.btnRename) {
            BatchRenameConfirmationDialog batchRenameConfirmationDialog;
            int n = this.files.size();
            int n2 = this.removeUnchangedFiles(true);
            if (n2 > 0 && (batchRenameConfirmationDialog = new BatchRenameConfirmationDialog(this.mainFrame, this.files, n2, n)).isProceedWithRename()) {
                this.dispose();
                this.doRename();
            }
        } else if (object == this.cbCase) {
            this.generateNewNames();
        } else if (object == this.cbCounterDigits) {
            this.generateNewNames();
        } else if (object == this.btnName) {
            this.insertPattern("[N]");
        } else if (object == this.btnExtension) {
            this.insertPattern("[E]");
        } else if (object == this.btnCounter) {
            this.insertPattern("[C]");
        } else if (object == this.btnNameRange) {
            String string = ((AbstractFile)this.files.get(0)).getNameWithoutExtension();
            BatchRenameSelectRange batchRenameSelectRange = new BatchRenameSelectRange((Dialog)this, string);
            batchRenameSelectRange.showDialog();
            String string2 = batchRenameSelectRange.getRange();
            if (string2 != null) {
                this.insertPattern(string2);
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.generateNewNames();
    }

    public void insertUpdate(DocumentEvent e) {
        this.generateNewNames();
    }

    public void removeUpdate(DocumentEvent e) {
        this.generateNewNames();
    }

    static class DateToken
    extends AbstractToken {
        private NumberFormat year = NumberFormat.getIntegerInstance();
        private NumberFormat digits2;

        public DateToken(String token) {
            super(token);
            this.year.setMinimumIntegerDigits(4);
            this.year.setGroupingUsed(false);
            this.digits2 = NumberFormat.getIntegerInstance();
            this.digits2.setMinimumIntegerDigits(2);
            this.digits2.setGroupingUsed(false);
        }

        public String apply(AbstractFile file) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(file.getDate());
            StringBuilder result = new StringBuilder();
            block8: for (int i = 0; i < this.len; ++i) {
                switch (this.token.charAt(i)) {
                    case 'Y': {
                        result.append(this.year.format(c.get(1)));
                        continue block8;
                    }
                    case 'M': {
                        result.append(this.digits2.format(c.get(2)));
                        continue block8;
                    }
                    case 'D': {
                        result.append(this.digits2.format(c.get(5)));
                        continue block8;
                    }
                    case 'h': {
                        result.append(this.digits2.format(c.get(11)));
                        continue block8;
                    }
                    case 'm': {
                        result.append(this.digits2.format(c.get(12)));
                        continue block8;
                    }
                    case 's': {
                        result.append(this.digits2.format(c.get(13)));
                    }
                }
            }
            return result.toString();
        }

        protected void parse() {
        }
    }

    static class ParentDirToken
    extends NameToken {
        public ParentDirToken(String token) {
            super(token);
        }

        public String apply(AbstractFile file) {
            AbstractFile parent = file.getParent();
            if (parent != null) {
                return this.extractNamePart(parent.getName());
            }
            return "";
        }
    }

    static class CounterToken
    extends AbstractToken {
        private int start;
        private int step;
        private int digits;
        private int current;
        private NumberFormat numberFormat;

        public CounterToken(String token, int start, int step, int digits) {
            super(token);
            this.start = start;
            this.step = step;
            this.digits = digits;
        }

        protected void parse() {
            this.start = this.getInt(this.start);
            if (this.getChar() == ',') {
                this.step = this.getInt(this.step);
                if (this.getChar() == ',') {
                    this.digits = this.getInt(this.digits);
                }
            }
            this.numberFormat = NumberFormat.getIntegerInstance();
            this.numberFormat.setMinimumIntegerDigits(this.digits);
            this.numberFormat.setGroupingUsed(false);
            this.current = this.start;
        }

        public String apply(AbstractFile file) {
            String counter = this.numberFormat.format(this.current);
            this.current += this.step;
            return counter;
        }
    }

    static class ExtToken
    extends NameToken {
        public ExtToken(String token) {
            super(token);
        }

        public String apply(AbstractFile file) {
            String oldName = file.getName();
            int dot = oldName.lastIndexOf(46);
            String ext = dot >= 0 ? oldName.substring(dot + 1) : "";
            return this.extractNamePart(ext);
        }
    }

    static class NameToken
    extends AbstractToken {
        private int startIndex;
        private int endIndex;
        private int charCount;

        public NameToken(String token) {
            super(token);
        }

        protected void parse() {
            this.startIndex = this.getInt(0);
            char sep = this.getChar();
            switch (sep) {
                case '-': {
                    this.endIndex = this.getInt(999);
                    break;
                }
                case ',': {
                    this.charCount = this.getInt(0);
                }
            }
        }

        public String apply(AbstractFile file) {
            String oldName = file.getName();
            int dot = oldName.lastIndexOf(46);
            String name = dot >= 0 ? oldName.substring(0, dot) : oldName;
            return this.extractNamePart(name);
        }

        protected String extractNamePart(String name) {
            int targetLen = name.length();
            int currentStartIndex = this.startIndex;
            int currentEndIndex = this.endIndex;
            if (currentStartIndex < 0 && (currentStartIndex = targetLen + currentStartIndex + 1) < 1) {
                currentStartIndex = 1;
            }
            if (currentEndIndex < 0) {
                currentEndIndex = targetLen + currentEndIndex + 1;
            }
            if (currentStartIndex > 0) {
                if (this.charCount > 0) {
                    currentEndIndex = currentStartIndex + this.charCount - 1;
                } else if (currentEndIndex == 0) {
                    currentEndIndex = currentStartIndex;
                }
                if (currentStartIndex <= currentEndIndex && currentStartIndex - 1 < targetLen) {
                    try {
                        name = name.substring(currentStartIndex - 1, Math.min(currentEndIndex, targetLen));
                    }
                    catch (Exception e) {
                        LOGGER.info("currentStartIndex=" + currentStartIndex + ", currentEndIndex=" + currentEndIndex, e);
                    }
                } else {
                    name = "";
                }
            }
            return name;
        }
    }

    static class CopyChar
    extends AbstractToken {
        public CopyChar(String token) {
            super(token);
        }

        protected void parse() {
        }

        public String apply(AbstractFile file) {
            return this.token;
        }
    }

    private static abstract class AbstractToken {
        protected String token;
        protected int pos = 1;
        protected int len;

        public AbstractToken(String token) {
            this.token = token;
            this.len = token.length();
        }

        protected abstract void parse();

        public abstract String apply(AbstractFile var1);

        public char getChar() {
            if (this.pos < this.len) {
                return this.token.charAt(this.pos++);
            }
            return '\u0000';
        }

        public int getInt(int def) {
            char c;
            int startpos = this.pos;
            while (this.pos < this.len && ((c = this.token.charAt(this.pos)) >= '0' && c <= '9' || c == '-' && startpos == this.pos)) {
                ++this.pos;
            }
            if (startpos == this.pos) {
                return def;
            }
            return StringUtils.parseIntDef(this.token.substring(startpos, this.pos), def);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RenameTableModel
    extends AbstractTableModel {
        private RenameTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return BatchRenameDialog.this.files.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AbstractFile f = (AbstractFile)BatchRenameDialog.this.files.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return f.getName();
                }
                case 1: {
                    return BatchRenameDialog.this.newNames.get(rowIndex);
                }
                case 2: {
                    return BatchRenameDialog.this.blockNames.get(rowIndex);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    if (((String)BatchRenameDialog.this.newNames.get(rowIndex)).equals(value)) break;
                    BatchRenameDialog.this.newNames.set(rowIndex, (String)value);
                    if (Boolean.FALSE.equals(BatchRenameDialog.this.blockNames.get(rowIndex))) {
                        BatchRenameDialog.this.blockNames.set(rowIndex, Boolean.TRUE);
                        if (BatchRenameDialog.this.tblNames.getColumnCount() == 2) {
                            BatchRenameDialog.this.tblNames.addColumn(BatchRenameDialog.this.colBlock);
                        }
                        this.fireTableCellUpdated(rowIndex, 2);
                    }
                    BatchRenameDialog.this.checkForDuplicates();
                    break;
                }
                case 2: {
                    BatchRenameDialog.this.blockNames.set(rowIndex, (Boolean)value);
                    if (Boolean.FALSE.equals(value)) {
                        AbstractFile file = (AbstractFile)BatchRenameDialog.this.files.get(rowIndex);
                        String newName = BatchRenameDialog.this.generateNewName(file);
                        BatchRenameDialog.this.newNames.set(rowIndex, newName);
                        this.fireTableCellUpdated(rowIndex, 1);
                    }
                    BatchRenameDialog.this.checkForDuplicates();
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Translator.get("batch_rename_dialog.old_name", new String[0]);
                }
                case 1: {
                    return Translator.get("batch_rename_dialog.new_name", new String[0]);
                }
                case 2: {
                    return Translator.get("batch_rename_dialog.block_name", new String[0]);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 2) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }
    }
}

