/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.debug;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.mucommander.MuLogging;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.ui.dialog.debug.LoggingEvent;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugConsoleAppender
extends AppenderBase<ILoggingEvent> {
    private int bufferSize;
    private List<LogbackLoggingEvent> loggingEventsList;
    private Layout<ILoggingEvent> loggingEventLayout;

    public DebugConsoleAppender(Layout<ILoggingEvent> loggingEventsLayout) {
        this.loggingEventLayout = loggingEventsLayout;
        this.bufferSize = MuConfigurations.getPreferences().getVariable(MuPreference.LOG_BUFFER_SIZE, 200);
        this.loggingEventsList = new LinkedList<LogbackLoggingEvent>();
    }

    public synchronized LoggingEvent[] getLogRecords() {
        LoggingEvent[] records = new LogbackLoggingEvent[]{};
        records = this.loggingEventsList.toArray(records);
        return records;
    }

    @Override
    protected void append(ILoggingEvent record) {
        if (this.loggingEventsList.size() == this.bufferSize) {
            this.loggingEventsList.remove(0);
        }
        this.loggingEventsList.add(new LogbackLoggingEvent(record));
    }

    public class LogbackLoggingEvent
    implements LoggingEvent {
        private ILoggingEvent loggingEvent;
        private MuLogging.LogLevel logLevel;

        LogbackLoggingEvent(ILoggingEvent lr) {
            this.loggingEvent = lr;
        }

        public String toString() {
            return DebugConsoleAppender.this.loggingEventLayout.doLayout(this.loggingEvent);
        }

        public boolean isLevelEqualOrHigherThan(MuLogging.LogLevel level) {
            return this.getLevel().compareTo(level) <= 0;
        }

        public MuLogging.LogLevel getLevel() {
            if (this.logLevel == null) {
                this.logLevel = MuLogging.getLevel(this.loggingEvent);
            }
            return this.logLevel;
        }
    }
}

