/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.bookmark;

import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.layout.XAlignedComponentPanel;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.list.DynamicList;
import com.mucommander.ui.list.SortableListPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.text.FilePathField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class EditBookmarksDialog
extends FocusDialog
implements ActionListener,
DocumentListener,
ListSelectionListener {
    private MainFrame mainFrame;
    private JButton newButton;
    private JButton duplicateButton;
    private JButton removeButton;
    private JButton goToButton;
    private JButton closeButton;
    private JTextField nameField;
    private JTextField locationField;
    private AlteredVector<Bookmark> bookmarks;
    private DynamicList<Bookmark> bookmarkList;
    private int currentListIndex;
    private Bookmark currentBookmarkSave;
    private boolean ignoreDocumentListenerEvents;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(440, 330);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(600, 400);

    public EditBookmarksDialog(MainFrame mainFrame) {
        super((Frame)mainFrame, ActionProperties.getActionLabel("EditBookmarks"), (Component)mainFrame);
        this.mainFrame = mainFrame;
        Container contentPane = this.getContentPane();
        this.bookmarks = BookmarkManager.getBookmarks();
        BookmarkManager.setFireEvents(false);
        SortableListPanel<Bookmark> listPanel = new SortableListPanel<Bookmark>(this.bookmarks);
        this.bookmarkList = listPanel.getDynamicList();
        contentPane.add(listPanel, "Center");
        XAlignedComponentPanel compPanel = new XAlignedComponentPanel();
        this.nameField = new JTextField();
        this.nameField.getDocument().addDocumentListener(this);
        compPanel.addRow(Translator.get("name", new String[0]) + ":", (JComponent)this.nameField, 5);
        this.locationField = new FilePathField();
        this.locationField.getDocument().addDocumentListener(this);
        compPanel.addRow(Translator.get("location", new String[0]) + ":", (JComponent)this.locationField, 10);
        YBoxPanel yPanel = new YBoxPanel(10);
        yPanel.add(compPanel);
        XBoxPanel buttonsPanel = new XBoxPanel();
        JPanel buttonGroupPanel = new JPanel(new FlowLayout(0));
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        this.newButton = new JButton(Translator.get("edit_bookmarks_dialog.new", new String[0]));
        this.newButton.setMnemonic(mnemonicHelper.getMnemonic(this.newButton));
        this.newButton.addActionListener(this);
        buttonGroupPanel.add(this.newButton);
        this.duplicateButton = new JButton(Translator.get("duplicate", new String[0]));
        this.duplicateButton.setMnemonic(mnemonicHelper.getMnemonic(this.duplicateButton));
        this.duplicateButton.addActionListener(this);
        buttonGroupPanel.add(this.duplicateButton);
        this.removeButton = new JButton(this.bookmarkList.getRemoveAction());
        this.removeButton.setMnemonic(mnemonicHelper.getMnemonic(this.removeButton));
        buttonGroupPanel.add(this.removeButton);
        this.goToButton = new JButton(Translator.get("go_to", new String[0]));
        this.goToButton.setMnemonic(mnemonicHelper.getMnemonic(this.goToButton));
        this.goToButton.addActionListener(this);
        buttonGroupPanel.add(this.goToButton);
        buttonsPanel.add(buttonGroupPanel);
        this.closeButton = new JButton(Translator.get("close", new String[0]));
        this.closeButton.setMnemonic(mnemonicHelper.getMnemonic(this.closeButton));
        this.closeButton.addActionListener(this);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.closeButton);
        yPanel.add(buttonsPanel);
        contentPane.add((Component)yPanel, "South");
        this.updateComponents();
        this.bookmarkList.addListSelectionListener(this);
        this.setInitialFocusComponent(this.bookmarkList);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.setDefaultCloseOperation(2);
        this.showDialog();
    }

    private void updateComponents() {
        String nameValue = null;
        String locationValue = null;
        boolean componentsEnabled = false;
        if (!this.bookmarkList.isSelectionEmpty() && this.bookmarks.size() > 0) {
            componentsEnabled = true;
            Bookmark b = (Bookmark)this.bookmarkList.getSelectedValue();
            nameValue = b.getName();
            locationValue = b.getLocation();
        }
        this.ignoreDocumentListenerEvents = true;
        this.nameField.setText(nameValue);
        this.nameField.setEnabled(componentsEnabled);
        this.locationField.setText(locationValue);
        this.locationField.setEnabled(componentsEnabled);
        this.ignoreDocumentListenerEvents = false;
        this.goToButton.setEnabled(componentsEnabled);
        this.duplicateButton.setEnabled(componentsEnabled);
        this.removeButton.setEnabled(componentsEnabled);
    }

    private void modifyBookmark(Document sourceDocument) {
        if (this.ignoreDocumentListenerEvents || this.bookmarks.size() == 0) {
            return;
        }
        int selectedIndex = this.bookmarkList.getSelectedIndex();
        if (!this.bookmarkList.isIndexValid(selectedIndex)) {
            return;
        }
        Bookmark selectedBookmark = (Bookmark)this.bookmarks.elementAt(selectedIndex);
        if (this.currentBookmarkSave == null) {
            try {
                this.currentBookmarkSave = (Bookmark)selectedBookmark.clone();
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
            this.currentListIndex = selectedIndex;
        }
        if (sourceDocument == this.nameField.getDocument()) {
            String name = this.nameField.getText();
            if (name.trim().equals("")) {
                name = this.getFreeNameVariation(Translator.get("untitled", new String[0]));
            }
            selectedBookmark.setName(name);
            this.bookmarkList.itemModified(selectedIndex, false);
        } else {
            selectedBookmark.setLocation(this.locationField.getText());
        }
    }

    private String getFreeNameVariation(String name) {
        String newName;
        char c;
        if (!this.containsName(name)) {
            return name;
        }
        int len = name.length();
        int num = 2;
        if (len > 4 && name.charAt(len - 1) == ')' && (c = name.charAt(len - 2)) >= '0' && c <= '9' && name.charAt(len - 3) == '(' && name.charAt(len - 4) == ' ') {
            num = c - 48 + 1;
            name = name.substring(0, len - 4);
        }
        while (this.containsName(newName = name + " (" + num++ + ")")) {
        }
        return newName;
    }

    private boolean containsName(String name) {
        int nbBookmarks = this.bookmarks.size();
        for (int i = 0; i < nbBookmarks; ++i) {
            if (!((Bookmark)this.bookmarks.elementAt(i)).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.currentBookmarkSave != null) {
            this.bookmarks.setElementAt(this.currentBookmarkSave, this.currentListIndex);
            this.currentBookmarkSave = null;
        }
        BookmarkManager.setFireEvents(true);
        try {
            BookmarkManager.writeBookmarks(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.currentBookmarkSave = null;
            this.dispose();
        } else if (source == this.newButton || source == this.duplicateButton) {
            Bookmark newBookmark;
            if (source == this.newButton) {
                newBookmark = new Bookmark(this.getFreeNameVariation(Translator.get("untitled", new String[0])), "");
            } else {
                try {
                    Bookmark currentBookmark = (Bookmark)this.bookmarkList.getSelectedValue();
                    newBookmark = (Bookmark)currentBookmark.clone();
                    newBookmark.setName(this.getFreeNameVariation(currentBookmark.getName()));
                }
                catch (CloneNotSupportedException ex) {
                    return;
                }
            }
            this.bookmarks.add(newBookmark);
            int newBookmarkIndex = this.bookmarks.size() - 1;
            this.bookmarkList.selectAndScroll(newBookmarkIndex);
            this.updateComponents();
            this.nameField.selectAll();
            this.nameField.requestFocus();
        } else if (source == this.goToButton) {
            this.dispose();
            this.mainFrame.getActivePanel().tryChangeCurrentFolder(((Bookmark)this.bookmarkList.getSelectedValue()).getLocation());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.currentBookmarkSave = null;
        this.updateComponents();
    }

    public void changedUpdate(DocumentEvent e) {
        this.modifyBookmark(e.getDocument());
    }

    public void insertUpdate(DocumentEvent e) {
        this.modifyBookmark(e.getDocument());
    }

    public void removeUpdate(DocumentEvent e) {
        this.modifyBookmark(e.getDocument());
    }
}

