/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog.about;

import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.theme.ThemeManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseDialog
extends FocusDialog
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseDialog.class);
    private JButton okButton;
    private JScrollPane licensePanel;

    public LicenseDialog(Dialog dialog) {
        super(dialog, Translator.get("license", new String[0]), (Component)dialog);
        this.initUI();
    }

    public LicenseDialog(Frame frame) {
        super(frame, Translator.get("license", new String[0]), (Component)frame);
        this.initUI();
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(Translator.get("ok", new String[0]));
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        return panel;
    }

    private JScrollPane createLicensePanel() {
        JTextArea license = new JTextArea();
        license.setEditable(false);
        license.setForeground(ThemeManager.getCurrentColor(41));
        license.setBackground(ThemeManager.getCurrentColor(42));
        license.setSelectedTextColor(ThemeManager.getCurrentColor(43));
        license.setSelectionColor(ThemeManager.getCurrentColor(44));
        license.setFont(ThemeManager.getCurrentFont(2));
        license.setText(this.getLicenseText());
        this.licensePanel = new JScrollPane(license, 20, 31);
        this.licensePanel.getViewport().setPreferredSize(new Dimension((int)license.getPreferredSize().getWidth(), 400));
        return this.licensePanel;
    }

    private void initUI() {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.createLicensePanel(), "Center");
        contentPane.add((Component)this.createButtonPanel(), "South");
        this.setInitialFocusComponent(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LicenseDialog.this.licensePanel.getViewport().setViewPosition(new Point(0, 0));
            }
        });
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLicenseText() {
        InputStreamReader inputStreamReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            inputStreamReader = new InputStreamReader(LicenseDialog.class.getResourceAsStream("/license.txt"));
            char[] cArray = new char[2048];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to read license file", exception);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return stringBuilder.toString();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.dispose();
        }
    }
}

