/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog;

import com.mucommander.job.ui.DialogResult;
import com.mucommander.ui.button.ButtonChoicePanel;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.InformationPane;
import com.mucommander.ui.layout.YBoxPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

public class QuestionDialog
extends FocusDialog
implements DialogResult,
ActionListener {
    private JButton[] buttons;
    private int[] actionValues;
    private int retValue = -1;
    private YBoxPanel mainPanel;
    private static final Dimension MINIMUM_DIALOG_DIMENSION = new Dimension(360, 0);
    private static final Dimension MAXIMUM_DIALOG_DIMENSION = new Dimension(480, 10000);

    public QuestionDialog(Frame owner, String title, String msg, Component locationRelative, String[] actionText, int[] actionValues, int maxNbCols) {
        super(owner, title, locationRelative);
        this.init(new InformationPane(msg, null, 0, 4), actionText, actionValues, maxNbCols);
    }

    public QuestionDialog(Dialog owner, String title, String msg, Component locationRelative, String[] actionText, int[] actionValues, int maxNbCols) {
        super(owner, title, locationRelative);
        this.init(new InformationPane(msg, null, 0, 4), actionText, actionValues, maxNbCols);
    }

    protected QuestionDialog(Frame owner, String title, Component locationRelative) {
        super(owner, title, locationRelative);
    }

    protected QuestionDialog(Dialog owner, String title, Component locationRelative) {
        super(owner, title, locationRelative);
    }

    protected void init(Component comp, String[] actionText, int[] actionValues, int maxNbCols) {
        this.actionValues = actionValues;
        this.setMinimumSize(MINIMUM_DIALOG_DIMENSION);
        this.setMaximumSize(MAXIMUM_DIALOG_DIMENSION);
        this.mainPanel = new YBoxPanel();
        if (comp != null) {
            this.mainPanel.addSpace(5);
            this.mainPanel.add(comp);
            this.mainPanel.addSpace(10);
        }
        int nbButtons = actionText.length;
        this.buttons = new JButton[nbButtons];
        for (int i = 0; i < nbButtons; ++i) {
            String text = actionText[i];
            this.buttons[i] = new JButton(text);
            this.buttons[i].addActionListener(this);
        }
        this.setInitialFocusComponent(this.buttons[0]);
        this.mainPanel.add(new ButtonChoicePanel(this.buttons, maxNbCols, this.getRootPane()));
        this.getContentPane().add((Component)this.mainPanel, "North");
    }

    protected void addComponent(JComponent comp) {
        this.mainPanel.add(comp);
    }

    public int getActionValue() {
        super.showDialog();
        return this.retValue;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] != source) continue;
            this.retValue = this.actionValues[i];
            break;
        }
        this.dispose();
    }

    public Object getUserInput() {
        super.showDialog();
        return this.retValue;
    }
}

