/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog;

import com.mucommander.text.Translator;
import com.mucommander.ui.button.CollapseExpandButton;
import com.mucommander.ui.dialog.DialogToolkit;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.InformationPane;
import com.mucommander.ui.layout.YBoxPanel;
import com.mucommander.ui.text.FontUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InformationDialog {
    private static final Dimension MIN_DIALOG_SIZE = new Dimension(360, 0);
    private static final Dimension MAX_DIALOG_SIZE = new Dimension(480, 10000);

    public static void showErrorDialog(Component parentComponent) {
        InformationDialog.showErrorDialog(parentComponent, null, null, null, null);
    }

    public static void showErrorDialog(Component parentComponent, String message) {
        InformationDialog.showErrorDialog(parentComponent, null, message, null, null);
    }

    public static void showErrorDialog(Component parentComponent, String title, String message) {
        InformationDialog.showErrorDialog(parentComponent, title, message, null, null);
    }

    public static void showErrorDialog(Component parentComponent, String title, String message, String captionMessage, Throwable throwable) {
        InformationDialog.showDialog(1, parentComponent, title == null ? Translator.get("error", new String[0]) : title, message == null ? Translator.get("generic_error", new String[0]) : message, captionMessage, throwable);
    }

    public static void showWarningDialog(Component parentComponent, String message) {
        InformationDialog.showWarningDialog(parentComponent, null, message, null);
    }

    public static void showWarningDialog(Component parentComponent, String title, String message, String captionMessage) {
        InformationDialog.showDialog(3, parentComponent, title == null ? Translator.get("warning", new String[0]) : title, message, captionMessage, null);
    }

    public static void showDialog(int dialogType, Component parentComponent, String title, String message, String captionMessage, Throwable throwable) {
        Window owner = DialogToolkit.getWindowForComponent(parentComponent);
        final FocusDialog dialog = owner instanceof Frame ? new FocusDialog((Frame)owner, title, parentComponent) : new FocusDialog((Dialog)owner, title, parentComponent);
        dialog.setMinimumSize(MIN_DIALOG_SIZE);
        dialog.setMaximumSize(MAX_DIALOG_SIZE);
        YBoxPanel mainPanel = new YBoxPanel();
        InformationPane informationPane = new InformationPane(message, captionMessage, captionMessage == null ? 0 : 1, InformationDialog.getInformationPaneIconId(dialogType));
        mainPanel.add(informationPane);
        mainPanel.addSpace(10);
        JButton okButton = new JButton(Translator.get("ok", new String[0]));
        JPanel okPanel = DialogToolkit.createOKPanel(okButton, dialog.getRootPane(), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        mainPanel.add(buttonPanel);
        if (throwable != null) {
            JTextArea detailsArea = new JTextArea();
            detailsArea.setEditable(false);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            throwable.printStackTrace(pw);
            pw.close();
            detailsArea.setText(sw.toString().replace('\t', ' '));
            FontUtils.makeMini(detailsArea);
            JScrollPane scrollPane = new JScrollPane(detailsArea, 20, 30);
            buttonPanel.add(new CollapseExpandButton(Translator.get("details", new String[0]), scrollPane, false));
            mainPanel.add(scrollPane);
        }
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(okPanel);
        dialog.getContentPane().add(mainPanel);
        dialog.setInitialFocusComponent(okButton);
        dialog.setDefaultCloseOperation(2);
        dialog.showDialog();
    }

    private static int getInformationPaneIconId(int dialogType) {
        int iconId;
        switch (dialogType) {
            case 1: {
                iconId = 1;
                break;
            }
            case 2: {
                iconId = 2;
                break;
            }
            case 3: {
                iconId = 3;
                break;
            }
            case 4: {
                iconId = 4;
                break;
            }
            default: {
                iconId = 1;
            }
        }
        return iconId;
    }
}

