/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.dialog;

import com.mucommander.ui.button.ButtonChoicePanel;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.main.WindowManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class DialogToolkit {
    public static boolean fitToMinDimension(Window window, Dimension minD) {
        return DialogToolkit.fitToDimension(window, minD, true);
    }

    public static boolean fitToMaxDimension(Window window, Dimension maxD) {
        return DialogToolkit.fitToDimension(window, maxD, false);
    }

    public static boolean fitToScreen(Window window) {
        Rectangle screenBounds = WindowManager.getFullScreenBounds(window);
        return DialogToolkit.fitToMaxDimension(window, new Dimension((int)screenBounds.getWidth(), (int)screenBounds.getHeight()));
    }

    private static boolean fitToDimension(Window window, Dimension d, boolean min) {
        int maxWidth = (int)d.getWidth();
        int maxHeight = (int)d.getHeight();
        int windowWidth = window.getWidth();
        int windowHeight = window.getHeight();
        boolean changeSize = false;
        if (min) {
            if (windowWidth < maxWidth) {
                windowWidth = maxWidth;
                changeSize = true;
            }
            if (windowHeight < maxHeight) {
                windowHeight = maxHeight;
                changeSize = true;
            }
        } else {
            if (windowWidth > maxWidth) {
                windowWidth = maxWidth;
                changeSize = true;
            }
            if (windowHeight > maxHeight) {
                windowHeight = maxHeight;
                changeSize = true;
            }
        }
        if (changeSize) {
            window.setSize(windowWidth, windowHeight);
        }
        return changeSize;
    }

    public static void centerOnScreen(Component c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        c.setLocation(screenSize.width / 2 - c.getWidth() / 2, screenSize.height / 2 - c.getHeight() / 2);
    }

    public static void centerOnWindow(Component c, Window window) {
        int x = Math.max(0, window.getX() + (window.getWidth() - c.getWidth()) / 2);
        int y = Math.max(0, window.getY() + (window.getHeight() - c.getHeight()) / 2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int buffer = screenSize.width - (c.getWidth() + x);
        if (buffer < 0) {
            x += buffer;
        }
        if ((buffer = screenSize.height - (c.getHeight() + y)) < 0) {
            y += buffer;
        }
        c.setLocation(x, y);
    }

    public static JPanel createOKCancelPanel(JButton okButton, JButton cancelButton, JRootPane rootPane, ActionListener actionListener) {
        return DialogToolkit.createButtonPanel(new JButton[]{okButton, cancelButton}, rootPane, actionListener);
    }

    public static JPanel createOKPanel(JButton okButton, JRootPane rootPane, ActionListener actionListener) {
        return DialogToolkit.createButtonPanel(new JButton[]{okButton}, rootPane, actionListener);
    }

    public static JPanel createButtonPanel(JButton[] buttons, JRootPane rootPane, ActionListener actionListener) {
        ButtonChoicePanel panel = new ButtonChoicePanel(buttons, 0, rootPane);
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        for (JButton button : buttons) {
            button.setMnemonic(mnemonicHelper.getMnemonic(button.getText()));
            button.addActionListener(actionListener);
            panel.add(button);
        }
        return panel;
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return DialogToolkit.getWindowForComponent(parentComponent.getParent());
    }
}

