/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.combobox;

import com.mucommander.ui.combobox.ComboBoxListener;
import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaneComboBox
extends JComboBox {
    private WeakHashMap<ComboBoxListener, Object> listeners = new WeakHashMap();
    private boolean ignoreActionEvent;

    public SaneComboBox() {
        this.init();
    }

    public SaneComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init();
    }

    public SaneComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public SaneComboBox(Vector<Object> items) {
        super(items);
        this.init();
    }

    private void init() {
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SaneComboBox.this.ignoreActionEvent) {
                    SaneComboBox.this.fireComboBoxSelectionChanged();
                }
            }
        });
    }

    public void addComboBoxListener(ComboBoxListener listener) {
        this.listeners.put(listener, null);
    }

    protected void fireComboBoxSelectionChanged() {
        for (ComboBoxListener listener : this.listeners.keySet()) {
            listener.comboBoxSelectionChanged(this);
        }
    }

    public void addItem(Object object) {
        this.ignoreActionEvent = true;
        super.addItem(object);
        this.ignoreActionEvent = false;
    }

    public void insertItemAt(Object object, int i) {
        this.ignoreActionEvent = true;
        super.insertItemAt(object, i);
        this.ignoreActionEvent = false;
    }

    @Override
    public void removeItem(Object object) {
        this.ignoreActionEvent = true;
        super.removeItem(object);
        this.ignoreActionEvent = false;
    }

    @Override
    public void removeItemAt(int i) {
        this.ignoreActionEvent = true;
        super.removeItemAt(i);
        this.ignoreActionEvent = false;
    }

    @Override
    public void removeAllItems() {
        this.ignoreActionEvent = true;
        super.removeAllItems();
        this.ignoreActionEvent = false;
    }
}

