/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.combobox;

import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.ui.combobox.ComboBoxCellRenderer;
import com.mucommander.ui.combobox.EditableComboBoxListener;
import com.mucommander.ui.combobox.SaneComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.WeakHashMap;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class EditableComboBox
extends SaneComboBox {
    private ComboBoxCellRenderer renderer;
    private JTextField textField;
    private WeakHashMap<EditableComboBoxListener, Object> listeners = new WeakHashMap();
    private boolean comboSelectionUpdatesTextField;

    public EditableComboBox() {
        this.init(null);
    }

    public EditableComboBox(JTextField textField) {
        this.init(textField);
    }

    public EditableComboBox(JTextField textField, Object[] items) {
        super(items);
        this.init(textField);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setComboSelectionUpdatesTextField(boolean comboSelectionUpdatesTextField) {
        this.comboSelectionUpdatesTextField = comboSelectionUpdatesTextField;
    }

    private void init(JTextField textField) {
        this.renderer = new ComboBoxCellRenderer();
        this.setRenderer(this.renderer);
        this.textField = textField == null ? new JTextField() : textField;
        this.setEditor(new BasicComboBoxEditor(){

            public Component getEditorComponent() {
                return EditableComboBox.this.textField;
            }
        });
        this.setEditable(true);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int keyCode = keyEvent.getKeyCode();
                if (EditableComboBox.this.isPopupVisible()) {
                    if (keyCode == 10) {
                        if (JavaVersions.JAVA_1_5.isCurrentOrLower()) {
                            EditableComboBox.this.hidePopup();
                        }
                    } else if (keyCode == 27) {
                        EditableComboBox.this.hidePopup();
                        keyEvent.consume();
                    }
                } else if (keyCode == 10) {
                    EditableComboBox.this.fireComboFieldValidated();
                    keyEvent.consume();
                } else if (keyCode == 27) {
                    EditableComboBox.this.fireComboFieldCancelled();
                }
            }
        });
    }

    public void addEditableComboBoxListener(EditableComboBoxListener listener) {
        this.addComboBoxListener(listener);
        this.listeners.put(listener, null);
    }

    protected void fireComboBoxSelectionChanged() {
        if (this.comboSelectionUpdatesTextField && this.getSelectedIndex() != -1) {
            this.textField.setText(this.getSelectedItem().toString());
        }
        super.fireComboBoxSelectionChanged();
    }

    protected void fireComboFieldValidated() {
        for (EditableComboBoxListener listener : this.listeners.keySet()) {
            listener.textFieldValidated(this);
        }
    }

    protected void fireComboFieldCancelled() {
        for (EditableComboBoxListener listener : this.listeners.keySet()) {
            listener.textFieldCancelled(this);
        }
    }

    public void setForeground(Color color) {
        if (this.renderer == null) {
            super.setForeground(color);
        } else {
            this.renderer.setForeground(color);
            this.textField.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        if (this.renderer == null) {
            super.setBackground(color);
        } else {
            this.renderer.setBackground(color);
            this.textField.setBackground(color);
        }
    }

    public void setSelectionForeground(Color color) {
        if (this.renderer != null) {
            this.renderer.setSelectionForeground(color);
            this.textField.setSelectedTextColor(color);
        }
    }

    public void setSelectionBackground(Color color) {
        if (this.renderer != null) {
            this.renderer.setSelectionBackground(color);
            this.textField.setSelectionColor(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.renderer != null) {
            this.renderer.setFont(font);
            this.textField.setFont(font);
        }
    }
}

