/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.combobox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxCellRenderer
implements ListCellRenderer {
    private Color textColor;
    private Color backgroundColor;
    private Color selectedTextColor;
    private Color selectedBackgroundColor;
    private Font font;
    private JLabel label = new JLabel();

    public ComboBoxCellRenderer() {
        this.label.setOpaque(true);
    }

    public void setForeground(Color color) {
        this.textColor = color;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setSelectionForeground(Color color) {
        this.selectedTextColor = color;
    }

    public void setSelectionBackground(Color color) {
        this.selectedBackgroundColor = color;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (value != null) {
            this.label.setText(value.toString());
        }
        if (this.font == null) {
            this.label.setFont(list.getFont());
        } else {
            this.label.setFont(this.font);
        }
        if (isSelected) {
            if (this.selectedBackgroundColor == null) {
                this.label.setBackground(list.getSelectionBackground());
            } else {
                this.label.setBackground(this.selectedBackgroundColor);
            }
            if (this.selectedTextColor == null) {
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setForeground(this.selectedTextColor);
            }
        } else {
            if (this.backgroundColor == null) {
                this.label.setBackground(list.getBackground());
            } else {
                this.label.setBackground(this.backgroundColor);
            }
            if (this.textColor == null) {
                this.label.setForeground(list.getForeground());
            } else {
                this.label.setForeground(this.textColor);
            }
        }
        return this.label;
    }
}

