/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.chooser;

import com.mucommander.text.Translator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class PreviewLabel
extends JLabel
implements PropertyChangeListener,
Cloneable {
    private Color overlayColor;
    private Border border;
    private boolean overlayUnderText;

    public PreviewLabel() {
        super(" ");
        this.addPropertyChangeListener(this);
    }

    public void setTextPainted(boolean b) {
        if (b) {
            this.setText(Translator.get("sample_text", new String[0]));
        } else {
            this.setText(" ");
        }
    }

    public void setOverlayUnderText(boolean b) {
        this.overlayUnderText = b;
        this.repaint();
    }

    private void paintText(Graphics g) {
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        g.drawString(this.getText(), (this.getWidth() - metrics.stringWidth(this.getText())) / 2, (this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent());
    }

    public void setForeground(Color color) {
        this.putClientProperty("PreviewLabel.ForegroundColor", color);
    }

    public void setBackground(Color color) {
        this.putClientProperty("PreviewLabel.BackgroundColor", color);
    }

    public Object clone() throws CloneNotSupportedException {
        PreviewLabel label = (PreviewLabel)super.clone();
        label.addPropertyChangeListener(label);
        return label;
    }

    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        if (!this.overlayUnderText) {
            this.paintText(g);
        }
        if (this.overlayColor != null) {
            g.setColor(this.overlayColor);
            g.fillRect(0, 0, width / 2, height);
        }
        if (this.overlayUnderText) {
            this.paintText(g);
        }
        if (this.border != null) {
            this.border.paintBorder(this, g, 0, 0, width, height);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 8.0, dimension.getHeight() + 6.0);
        return dimension;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object value = event.getNewValue();
        if ("PreviewLabel.ForegroundColor".equals(name)) {
            super.setForeground((Color)value);
        } else if ("PreviewLabel.BackgroundColor".equals(name)) {
            super.setBackground((Color)value);
        } else if ("PreviewLabel.OverlayColor".equals(name)) {
            this.overlayColor = (Color)value;
            this.repaint();
        } else if ("PreviewLabel.BorderColor".equals(name)) {
            this.border = new LineBorder((Color)value, 1);
            this.repaint();
        }
    }
}

