/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.chooser;

import java.awt.Component;
import java.util.WeakHashMap;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntegerChooser
extends JPanel
implements ChangeListener {
    private WeakHashMap<ChangeListener, ?> listeners = new WeakHashMap();
    private JSlider slider;
    private JSpinner spinner;

    public IntegerChooser(int min, int max, int initialValue) {
        this.slider = new JSlider(0, min, max, initialValue);
        this.spinner = new JSpinner(new SpinnerNumberModel(initialValue, min, max, 1));
        this.slider.addChangeListener(this);
        this.spinner.addChangeListener(this);
        this.add(this.slider);
        this.add((Component)this.spinner, "East");
    }

    public void setMajorTickSpacing(int spacing) {
        this.slider.setMajorTickSpacing(spacing);
    }

    public void setMinorTickSpacing(int spacing) {
        this.slider.setMinorTickSpacing(spacing);
    }

    public void setPaintTicks(boolean b) {
        this.slider.setPaintTicks(b);
    }

    public void setPaintLabels(boolean b) {
        this.slider.setPaintLabels(b);
    }

    public void setValue(int value) {
        this.slider.setValue(value);
        this.spinner.setValue(value);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.put(listener, null);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spinner) {
            this.slider.setValue((Integer)this.spinner.getValue());
        } else if (e.getSource() == this.slider) {
            this.spinner.setValue(this.slider.getValue());
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners.keySet()) {
            listener.stateChanged(event);
        }
    }
}

