/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.chooser;

import com.mucommander.ui.chooser.ColorChangeEvent;
import com.mucommander.ui.chooser.ColorChangeListener;
import com.mucommander.ui.icon.IconManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ColorPicker
extends JButton
implements AWTEventListener,
ActionListener {
    private Robot robot;
    private boolean isActive;
    private WeakHashMap<ColorChangeListener, ?> listeners = new WeakHashMap();
    private static boolean isSupported;

    public ColorPicker() {
        super(IconManager.getIcon(3, "picker.png"));
        this.addActionListener(this);
    }

    public static boolean isSupported() {
        return isSupported;
    }

    public void setActive(boolean active) {
        if (active == this.isActive) {
            return;
        }
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (active) {
            if (!this.isVisible()) {
                return;
            }
            try {
                this.robot = new Robot(this.getTopLevelAncestor().getGraphicsConfiguration().getDevice());
            }
            catch (Exception e) {
                return;
            }
            this.setPickerCursor(Color.WHITE);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    toolkit.addAWTEventListener(ColorPicker.this, 48L);
                    ColorPicker.this.setSelected(true);
                }
            });
        } else {
            toolkit.removeAWTEventListener(this);
            this.setCustomCursor(Cursor.getDefaultCursor());
            this.setSelected(false);
        }
        this.isActive = active;
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        this.listeners.put(listener, null);
    }

    private void setPickerCursor(Color fillColor) {
        ImageIcon cursorIcon = (ImageIcon)this.getIcon();
        int iconWidth = cursorIcon.getIconWidth();
        int iconHeight = cursorIcon.getIconHeight();
        int colorRGB = fillColor.getRGB();
        BufferedImage iconMaskBi = new BufferedImage(iconWidth, iconHeight, 2);
        Graphics g = iconMaskBi.getGraphics();
        g.drawImage(IconManager.getIcon(3, "picker_mask.png").getImage(), 0, 0, null);
        for (int y = 0; y < iconHeight; ++y) {
            for (int x = 0; x < iconWidth; ++x) {
                int rgba = iconMaskBi.getRGB(x, y);
                if (rgba >> 24 == 0) continue;
                iconMaskBi.setRGB(x, y, colorRGB);
            }
        }
        BufferedImage iconBi = new BufferedImage(cursorIcon.getIconWidth(), cursorIcon.getIconHeight(), 2);
        g = iconBi.getGraphics();
        g.drawImage(cursorIcon.getImage(), 0, 0, null);
        g.drawImage(iconMaskBi, 0, 0, null);
        this.setCustomCursor(Toolkit.getDefaultToolkit().createCustomCursor(iconBi, new Point(0, 15), this.getClass().getName()));
    }

    private void setCustomCursor(Cursor cursor) {
        this.getTopLevelAncestor().setCursor(cursor);
    }

    private void fireColorPicked(Color color) {
        for (ColorChangeListener listener : this.listeners.keySet()) {
            listener.colorChanged(new ColorChangeEvent(this, color));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setActive(!this.isActive);
    }

    public void eventDispatched(AWTEvent awtEvent) {
        if (awtEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)awtEvent;
            Point mousePoint = mouseEvent.getPoint();
            Component source = (Component)mouseEvent.getSource();
            SwingUtilities.convertPointToScreen(mousePoint, source);
            int x = (int)mousePoint.getX();
            int y = (int)mousePoint.getY();
            Color color = this.robot.getPixelColor(x, y);
            int button = mouseEvent.getButton();
            if (button != 0) {
                if (button == 1 && (mouseEvent.getModifiers() & 0x1F4) != 0) {
                    if (source != this) {
                        this.fireColorPicked(color);
                    }
                    mouseEvent.consume();
                    this.setActive(false);
                }
                return;
            }
            this.setPickerCursor(color);
        }
    }

    static {
        try {
            new Robot();
            isSupported = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

