/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.chooser;

import com.mucommander.text.Translator;
import com.mucommander.ui.chooser.IntegerChooser;
import com.mucommander.ui.dialog.FocusDialog;
import com.mucommander.ui.layout.XBoxPanel;
import com.mucommander.ui.layout.YBoxPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooser
extends YBoxPanel
implements ChangeListener {
    private JComponent previewComponent;
    private JColorChooser chooser;
    private IntegerChooser alpha;
    private Color currentColor;
    private Color initialColor;
    private String previewColorPropertyName;

    public ColorChooser() {
        this(Color.WHITE, null, null);
    }

    public ColorChooser(Color initialColor, JComponent previewComponent, String previewColorPropertyName) {
        this.currentColor = initialColor;
        this.initialColor = initialColor;
        this.add(this.createChooserPanel());
        this.add(this.createTransparencyPanel());
        this.alpha.setValue(initialColor.getAlpha());
        this.chooser.setColor(initialColor);
        if (previewComponent != null && previewColorPropertyName != null) {
            this.previewComponent = previewComponent;
            this.previewColorPropertyName = previewColorPropertyName;
            this.add(this.createPreviewPanel(previewComponent));
            this.updatePreview();
        }
    }

    public static FocusDialog createDialog(Dialog parent, ColorChooser chooser) {
        return new ChooserDialog(parent, chooser);
    }

    private JPanel createPreviewPanel(JComponent previewComponent) {
        Dimension size = previewComponent.getPreferredSize();
        size.width = this.chooser.getPreferredSize().width;
        size.height *= 2;
        previewComponent.setPreferredSize(size);
        previewComponent.setOpaque(true);
        JPanel panel = new JPanel();
        panel.add(previewComponent);
        panel.setBorder(BorderFactory.createTitledBorder(Translator.get("preview", new String[0])));
        return panel;
    }

    private JColorChooser createChooserPanel() {
        this.chooser = new JColorChooser();
        this.chooser.setPreviewPanel(new JPanel());
        this.chooser.getSelectionModel().addChangeListener(this);
        return this.chooser;
    }

    private JPanel createTransparencyPanel() {
        this.alpha = new IntegerChooser(0, 255, 255);
        this.alpha.setMajorTickSpacing(85);
        this.alpha.setMinorTickSpacing(17);
        this.alpha.setPaintTicks(true);
        this.alpha.setPaintLabels(true);
        this.alpha.setBorder(BorderFactory.createTitledBorder(Translator.get("color_chooser.alpha", new String[0])));
        this.alpha.addChangeListener(this);
        return this.alpha;
    }

    public Color getColor() {
        return this.currentColor;
    }

    private void reset(boolean updateUI) {
        this.currentColor = this.initialColor;
        if (updateUI) {
            this.alpha.setValue(this.currentColor.getAlpha());
            this.chooser.setColor(this.currentColor);
            this.currentColor = this.initialColor;
            this.updatePreview();
        }
    }

    private void updatePreview() {
        if (this.previewComponent != null) {
            this.previewComponent.putClientProperty(this.previewColorPropertyName, this.currentColor);
        }
    }

    public void stateChanged(ChangeEvent e) {
        Color buffer = this.chooser.getColor();
        this.currentColor = new Color(buffer.getRed(), buffer.getGreen(), buffer.getBlue(), this.alpha.getValue());
        this.updatePreview();
    }

    static {
        UIManager.put("ColorChooser.rgbNameText", Translator.get("color_chooser.rgb", new String[0]));
        UIManager.put("ColorChooser.hsbNameText", Translator.get("color_chooser.hsb", new String[0]));
        UIManager.put("ColorChooser.swatchesNameText", Translator.get("color_chooser.swatches", new String[0]));
        String buffer = Translator.get("color_chooser.red", new String[0]);
        UIManager.put("ColorChooser.rgbRedText", buffer);
        UIManager.put("ColorChooser.hsbRedText", buffer);
        buffer = Translator.get("color_chooser.green", new String[0]);
        UIManager.put("ColorChooser.rgbGreenText", buffer);
        UIManager.put("ColorChooser.hsbGreenText", buffer);
        buffer = Translator.get("color_chooser.blue", new String[0]);
        UIManager.put("ColorChooser.rgbBlueText", buffer);
        UIManager.put("ColorChooser.hsbBlueText", buffer);
        UIManager.put("ColorChooser.hsbHueText", Translator.get("color_chooser.hue", new String[0]));
        UIManager.put("ColorChooser.hsbSaturationText", Translator.get("color_chooser.saturation", new String[0]));
        UIManager.put("ColorChooser.hsbBrightnessText", Translator.get("color_chooser.brightness", new String[0]));
        UIManager.put("ColorChooser.swatchesRecentText", Translator.get("color_chooser.recent", new String[0]));
    }

    private static class ChooserDialog
    extends FocusDialog
    implements ActionListener {
        private JButton resetButton;
        private JButton cancelButton;
        private ColorChooser chooser;

        public ChooserDialog(Dialog parent, ColorChooser chooser) {
            super(parent, Translator.get("color_chooser.title", new String[0]), (Component)parent);
            this.initUI(chooser);
        }

        private void initUI(ColorChooser chooser) {
            this.chooser = chooser;
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)chooser, "Center");
            contentPane.add((Component)this.createButtonsPanel(), "South");
        }

        private JPanel createButtonsPanel() {
            XBoxPanel buttonsPanel = new XBoxPanel();
            this.resetButton = new JButton(Translator.get("reset", new String[0]));
            buttonsPanel.add(this.resetButton);
            buttonsPanel.addSpace(20);
            JButton okButton = new JButton(Translator.get("ok", new String[0]));
            buttonsPanel.add(okButton);
            this.cancelButton = new JButton(Translator.get("cancel", new String[0]));
            buttonsPanel.add(this.cancelButton);
            this.resetButton.addActionListener(this);
            okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.getRootPane().setDefaultButton(okButton);
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(2));
            panel.add(buttonsPanel);
            return panel;
        }

        public void cancel() {
            this.chooser.reset(false);
            super.cancel();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.resetButton) {
                this.chooser.reset(true);
            } else {
                if (e.getSource() == this.cancelButton) {
                    this.chooser.reset(false);
                }
                this.dispose();
            }
        }
    }
}

