/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.button;

import com.mucommander.ui.action.impl.MuteProxyAction;
import com.mucommander.ui.button.NonFocusableButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class PopupButton
extends NonFocusableButton {
    private Action buttonClickedAction;
    private long popupMenuClosedTime;
    private JPopupMenu popupMenu;
    private int popupMenuLocation = 3;

    public PopupButton() {
        this((Action)null);
    }

    public PopupButton(Action buttonClickedAction) {
        this.setAction(buttonClickedAction);
        this.addMouseListener(new PopupMenuHandler());
    }

    public void setAction(Action buttonClickedAction) {
        if (buttonClickedAction == null) {
            super.setAction(null);
        } else {
            super.setAction(new MuteProxyAction(buttonClickedAction));
        }
        this.buttonClickedAction = buttonClickedAction;
    }

    public void setPopupMenuLocation(int location) {
        this.popupMenuLocation = location;
    }

    public boolean isPopupMenuVisible() {
        return this.popupMenu != null;
    }

    public synchronized void popupMenu() {
        this.popupMenu = this.getPopupMenu();
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.popupMenuClosed();
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.popupMenuClosed();
            }

            private void popupMenuClosed() {
                PopupButton.this.popupMenuClosedTime = System.currentTimeMillis();
                PopupButton.this.popupMenu = null;
                PopupButton.this.setSelected(false);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dimension popupMenuSize = PopupButton.this.popupMenu.getPreferredSize();
                PopupButton.this.popupMenu.show(PopupButton.this, PopupButton.this.popupMenuLocation == 4 ? PopupButton.this.getWidth() : (PopupButton.this.popupMenuLocation == 2 ? -((int)popupMenuSize.getWidth()) : (PopupButton.this.popupMenuLocation == 5 ? PopupButton.this.getWidth() - (int)popupMenuSize.getWidth() : 0)), PopupButton.this.popupMenuLocation == 3 ? PopupButton.this.getHeight() : (PopupButton.this.popupMenuLocation == 1 ? -((int)popupMenuSize.getHeight()) : (PopupButton.this.popupMenuLocation == 5 ? PopupButton.this.getHeight() : 0)));
            }
        });
        this.setSelected(true);
    }

    public abstract JPopupMenu getPopupMenu();

    private class PopupMenuHandler
    implements MouseListener,
    Runnable {
        private long pressedTime;

        private PopupMenuHandler() {
        }

        private boolean shouldIgnoreMouseEvent() {
            return PopupButton.this.isPopupMenuVisible() || System.currentTimeMillis() - PopupButton.this.popupMenuClosedTime < 300L;
        }

        public synchronized void mousePressed(MouseEvent mouseEvent) {
            if (!PopupButton.this.isEnabled() || this.shouldIgnoreMouseEvent()) {
                return;
            }
            this.pressedTime = System.currentTimeMillis();
            new Thread(this).start();
        }

        public synchronized void mouseClicked(MouseEvent mouseEvent) {
            if (!PopupButton.this.isEnabled() || this.shouldIgnoreMouseEvent()) {
                return;
            }
            this.pressedTime = 0L;
            if (PopupButton.this.buttonClickedAction != null) {
                PopupButton.this.buttonClickedAction.actionPerformed(new ActionEvent(PopupButton.this, 1001, "clicked"));
            } else {
                PopupButton.this.popupMenu();
            }
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
            this.pressedTime = 0L;
        }

        public synchronized void mouseExited(MouseEvent mouseEvent) {
            this.pressedTime = 0L;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PopupMenuHandler popupMenuHandler = this;
            synchronized (popupMenuHandler) {
                if (!PopupButton.this.isPopupMenuVisible() && this.pressedTime != 0L && System.currentTimeMillis() - this.pressedTime >= 300L) {
                    PopupButton.this.popupMenu();
                }
            }
        }
    }
}

