/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.button;

import com.mucommander.ui.helper.MnemonicHelper;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public class ButtonChoicePanel
extends JPanel
implements FocusListener,
KeyListener {
    private JButton[] buttons;
    private JRootPane rootPane;
    private int nbCols;
    private int nbRows;
    private int currentButton;
    private int nbButtons;

    public ButtonChoicePanel(JButton[] buttons, int nbCols, JRootPane rootPane) {
        this.buttons = buttons;
        this.nbButtons = buttons.length;
        this.nbCols = nbCols <= 0 ? this.nbButtons : nbCols;
        this.rootPane = rootPane;
        int n = nbCols <= 0 ? 1 : (this.nbRows = this.nbButtons / nbCols + (this.nbButtons % nbCols == 0 ? 0 : 1));
        if (nbCols <= 0) {
            this.setLayout(new FlowLayout(2));
        } else {
            this.setLayout(new GridLayout(0, nbCols));
        }
        for (int i = 0; i < this.nbButtons; ++i) {
            JButton button = buttons[i];
            button.addKeyListener(this);
            button.setDefaultCapable(true);
            button.addFocusListener(this);
            this.add(button);
        }
        this.updateMnemonics();
        rootPane.setDefaultButton(buttons[0]);
        this.currentButton = 0;
    }

    public void updateMnemonics() {
        MnemonicHelper mnemonicHelper = new MnemonicHelper();
        for (int i = 0; i < this.nbButtons; ++i) {
            JButton button = this.buttons[i];
            char mnemonic = mnemonicHelper.getMnemonic(button);
            if (mnemonic == '\u0000') continue;
            button.setMnemonic(mnemonic);
        }
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int oldCurrentButton = this.currentButton;
        if (keyCode == 37) {
            this.currentButton = this.currentButton == 0 ? this.nbButtons - 1 : this.currentButton - 1;
        } else if (keyCode == 39) {
            this.currentButton = this.currentButton == this.nbButtons - 1 ? 0 : this.currentButton + 1;
        } else if (keyCode == 38) {
            if (this.currentButton < this.nbCols) {
                this.currentButton = (this.nbRows - 1) * this.nbCols + this.currentButton % this.nbCols;
                if (this.currentButton > this.nbButtons - 1) {
                    this.currentButton -= this.nbCols;
                }
            } else {
                this.currentButton -= this.nbCols;
            }
        } else if (keyCode == 40) {
            this.currentButton = this.nbButtons - this.currentButton > 0 && this.nbButtons - this.currentButton <= this.nbCols ? (this.currentButton %= this.nbCols) : (this.currentButton += this.nbCols);
        } else if (!e.isAltDown()) {
            for (int i = 0; i < this.nbButtons; ++i) {
                if (keyCode != this.buttons[i].getMnemonic()) continue;
                this.buttons[i].doClick();
                return;
            }
        }
        if (oldCurrentButton != this.currentButton) {
            this.rootPane.setDefaultButton(this.buttons[this.currentButton]);
            this.buttons[this.currentButton].requestFocus();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.rootPane.setDefaultButton((JButton)focusEvent.getComponent());
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

