/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete.completers.services;

import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkListener;
import com.mucommander.bookmark.BookmarkManager;
import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.ui.autocomplete.completers.services.CompletionService;
import com.mucommander.ui.autocomplete.completers.services.PrefixFilter;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksService
implements BookmarkListener,
CompletionService {
    private String[] sortedBookmarkNames;
    private String[] sortedBookmarkLocations;

    public BookmarksService() {
        this.fetchBookmarks();
        BookmarkManager.addBookmarkListener(this);
    }

    @Override
    public Vector<String> getPossibleCompletions(String path) {
        Vector<String> result = new Vector<String>();
        PrefixFilter filter = PrefixFilter.createPrefixFilter(path);
        result.addAll(filter.filter(this.sortedBookmarkNames));
        result.addAll(filter.filter(this.sortedBookmarkLocations));
        return result;
    }

    @Override
    public String complete(String selectedCompletion) {
        int i;
        String result = null;
        int nbBookmarks = this.sortedBookmarkNames.length;
        for (i = 0; i < nbBookmarks; ++i) {
            if (!this.sortedBookmarkNames[i].equalsIgnoreCase(selectedCompletion)) continue;
            result = this.sortedBookmarkNames[i];
            break;
        }
        for (i = 0; i < nbBookmarks; ++i) {
            if (!this.sortedBookmarkLocations[i].equalsIgnoreCase(selectedCompletion)) continue;
            result = this.sortedBookmarkLocations[i];
            break;
        }
        return result;
    }

    private String[] getSortedBookmarkNames() {
        AlteredVector<Bookmark> bookmarks = BookmarkManager.getBookmarks();
        int nbBookmarks = bookmarks.size();
        String[] result = new String[nbBookmarks];
        for (int i = 0; i < nbBookmarks; ++i) {
            result[i] = ((Bookmark)bookmarks.elementAt(i)).getName();
        }
        Arrays.sort(result, String.CASE_INSENSITIVE_ORDER);
        return result;
    }

    private String[] getLocationsOfBookmarks() {
        int nbBookmarks = this.sortedBookmarkNames.length;
        String[] result = new String[nbBookmarks];
        for (int i = 0; i < nbBookmarks; ++i) {
            result[i] = BookmarkManager.getBookmark(this.sortedBookmarkNames[i]).getLocation();
        }
        Arrays.sort(result, String.CASE_INSENSITIVE_ORDER);
        return result;
    }

    protected void fetchBookmarks() {
        this.sortedBookmarkNames = this.getSortedBookmarkNames();
        this.sortedBookmarkLocations = this.getLocationsOfBookmarks();
    }

    @Override
    public void bookmarksChanged() {
        this.fetchBookmarks();
    }
}

