/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete;

import com.mucommander.ui.autocomplete.AutocompleterTextComponent;
import com.mucommander.ui.autocomplete.CompletionType;
import com.mucommander.ui.autocomplete.completers.Completer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableComboboxCompletion
extends CompletionType {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditableComboboxCompletion.class);

    public EditableComboboxCompletion(AutocompleterTextComponent comp, Completer completer) {
        super(comp, completer);
        this.autocompletedtextComp.getDocument().addDocumentListener(this.documentListener);
        this.autocompletedtextComp.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        if (EditableComboboxCompletion.this.isItemSelectedAtPopupList()) {
                            EditableComboboxCompletion.this.hideAutocompletionPopup();
                            EditableComboboxCompletion.this.acceptListItem((String)EditableComboboxCompletion.this.list.getSelectedValue());
                            keyEvent.consume();
                            break;
                        }
                        if (EditableComboboxCompletion.this.showingThread != null) {
                            EditableComboboxCompletion.this.showingThread.done();
                        }
                        EditableComboboxCompletion.this.autocompletedtextComp.OnEnterPressed(keyEvent);
                        break;
                    }
                    case 27: {
                        if (EditableComboboxCompletion.this.isPopupListShowing()) {
                            if (EditableComboboxCompletion.this.autocompletedtextComp.isEnabled()) {
                                EditableComboboxCompletion.this.hideAutocompletionPopup();
                            }
                            keyEvent.consume();
                            break;
                        }
                        EditableComboboxCompletion.this.autocompletedtextComp.OnEscPressed(keyEvent);
                        break;
                    }
                    case 38: {
                        if (!EditableComboboxCompletion.this.autocompletedtextComp.isEnabled() || !EditableComboboxCompletion.this.popup.isVisible()) break;
                        EditableComboboxCompletion.this.selectPreviousPossibleValue();
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        if (!EditableComboboxCompletion.this.autocompletedtextComp.isEnabled() || !EditableComboboxCompletion.this.popup.isVisible()) break;
                        EditableComboboxCompletion.this.selectNextPossibleValue();
                        keyEvent.consume();
                        break;
                    }
                    case 32: {
                        if (!keyEvent.isControlDown() || EditableComboboxCompletion.this.popup.isVisible()) break;
                        EditableComboboxCompletion.this.autocompletedtextComp.setComponentsPopupUnvisibe();
                        EditableComboboxCompletion.this.autocompletedtextComp.moveCarentToEndOfText();
                        EditableComboboxCompletion.this.createNewShowingThread(0);
                        break;
                    }
                    case 34: {
                        if (!EditableComboboxCompletion.this.autocompletedtextComp.isEnabled() || !EditableComboboxCompletion.this.isPopupListShowing()) break;
                        EditableComboboxCompletion.this.selectNextPage();
                        keyEvent.consume();
                        break;
                    }
                    case 33: {
                        if (!EditableComboboxCompletion.this.autocompletedtextComp.isEnabled() || !EditableComboboxCompletion.this.isItemSelectedAtPopupList()) break;
                        EditableComboboxCompletion.this.selectPreviousPage();
                        keyEvent.consume();
                        break;
                    }
                    case 36: {
                        if (!EditableComboboxCompletion.this.autocompletedtextComp.isEnabled() || !EditableComboboxCompletion.this.isPopupListShowing()) break;
                        EditableComboboxCompletion.this.selectFirstValue();
                        keyEvent.consume();
                        break;
                    }
                    case 35: {
                        if (!EditableComboboxCompletion.this.autocompletedtextComp.isEnabled() || !EditableComboboxCompletion.this.isPopupListShowing()) break;
                        EditableComboboxCompletion.this.selectLastValue();
                        keyEvent.consume();
                        break;
                    }
                    case 37: {
                        EditableComboboxCompletion.this.hideAutocompletionPopup();
                        break;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideAutocompletionPopup() {
        JPopupMenu jPopupMenu = this.popup;
        synchronized (jPopupMenu) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
        }
    }

    protected void startNewShowingThread(int delay) {
        this.showingThread = new ShowingThreadImp(delay);
        this.showingThread.start();
    }

    private class ShowingThreadImp
    extends CompletionType.ShowingThread {
        public ShowingThreadImp(int delay) {
            super(delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void showAutocompletionPopup() {
            if (EditableComboboxCompletion.this.autocompletedtextComp.isShowing() && EditableComboboxCompletion.this.autocompletedtextComp.isEnabled() && EditableComboboxCompletion.this.updateListData(EditableComboboxCompletion.this.list)) {
                int x;
                EditableComboboxCompletion.this.list.setVisibleRowCount(Math.min(EditableComboboxCompletion.this.list.getModel().getSize(), 10));
                try {
                    x = EditableComboboxCompletion.this.autocompletedtextComp.modelToView().x;
                }
                catch (BadLocationException e) {
                    LOGGER.debug("Caught exception", e);
                    return;
                }
                if (EditableComboboxCompletion.this.autocompletedtextComp.hasFocus() && !this.isStopped) {
                    EditableComboboxCompletion.this.list.ensureIndexIsVisible(0);
                    JPopupMenu jPopupMenu = EditableComboboxCompletion.this.popup;
                    synchronized (jPopupMenu) {
                        EditableComboboxCompletion.this.popup.show(EditableComboboxCompletion.this.autocompletedtextComp.getTextComponent(), x, EditableComboboxCompletion.this.autocompletedtextComp.getHeight());
                        EditableComboboxCompletion.this.popup.repaint();
                    }
                }
            }
        }
    }
}

