/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.autocomplete;

import com.mucommander.ui.autocomplete.AutocompleterTextComponent;
import com.mucommander.ui.autocomplete.completers.Completer;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class CompletionType {
    private Completer completer;
    protected AutocompleterTextComponent autocompletedtextComp;
    protected DocumentListener documentListener;
    protected JList list = new JList();
    protected JPopupMenu popup = new JPopupMenu();
    protected ShowingThread showingThread;
    protected final int VISIBLE_ROW_COUNT = 10;
    protected final int POPUP_DELAY_AT_TEXT_INSERTION = 1500;
    protected final int POPUP_DELAY_AT_TEXT_DELETION = 500;
    protected final int POPUP_DELAY_AFTER_ACCEPTING_LIST_ITEM = 1500;

    public CompletionType(AutocompleterTextComponent comp, Completer completer) {
        this.autocompletedtextComp = comp;
        this.completer = completer;
        JScrollPane scroll = new JScrollPane(this.list, 20, 31);
        scroll.setBorder(null);
        this.list.setFocusable(false);
        this.popup.setFocusable(false);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(scroll);
        this.createDocumentListener();
        this.addMouseListenerToList();
        this.list.setRequestFocusEnabled(false);
        this.autocompletedtextComp.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                CompletionType.this.hideAutocompletionPopup();
            }
        });
    }

    protected abstract void startNewShowingThread(int var1);

    protected abstract void hideAutocompletionPopup();

    protected boolean updateListData(JList list) {
        return this.completer.updateListData(list, this.autocompletedtextComp);
    }

    protected void updateTextComponent(String selected) {
        this.completer.updateTextComponent(selected, this.autocompletedtextComp);
    }

    protected void createNewShowingThread(int delay) {
        if (this.showingThread != null) {
            this.showingThread.done();
        }
        this.startNewShowingThread(delay);
    }

    protected void acceptListItem(String selected) {
        this.updateTextComponent(selected);
        this.createNewShowingThread(1500);
    }

    private void addMouseListenerToList() {
        this.list.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = CompletionType.this.list.locationToIndex(e.getPoint());
                    CompletionType.this.list.setSelectedIndex(index);
                    CompletionType.this.acceptListItem((String)CompletionType.this.list.getSelectedValue());
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }
        });
    }

    private void createDocumentListener() {
        this.documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                if (CompletionType.this.autocompletedtextComp.isCarentAtEndOfTextAtInsertion()) {
                    CompletionType.this.createNewShowingThread(CompletionType.this.popup.isVisible() ? 0 : 1500);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                if (CompletionType.this.autocompletedtextComp.isCarentAtEndOfTextAtRemoval()) {
                    CompletionType.this.createNewShowingThread(CompletionType.this.popup.isVisible() ? 0 : 500);
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    protected boolean isPopupListShowing() {
        return this.popup.isShowing();
    }

    protected boolean isItemSelectedAtPopupList() {
        return this.popup.isShowing() && this.list.getSelectedIndex() >= 0;
    }

    protected void selectFirstValue() {
        this.list.setSelectedIndex(0);
        this.list.ensureIndexIsVisible(0);
    }

    protected void selectLastValue() {
        int lastIndex = this.list.getModel().getSize() - 1;
        this.list.setSelectedIndex(lastIndex);
        this.list.ensureIndexIsVisible(lastIndex);
    }

    protected void selectNextPage() {
        int si = this.list.getSelectedIndex();
        int nextIndex = 0;
        if (si >= 0) {
            nextIndex = Math.min(si + 10 - 1, this.list.getModel().getSize() - 1);
        }
        this.list.setSelectedIndex(nextIndex);
        this.list.ensureIndexIsVisible(nextIndex);
    }

    protected void selectPreviousPage() {
        int si = this.list.getSelectedIndex();
        if (si > 0) {
            int nextIndex = Math.max(si - 9, 0);
            this.list.setSelectedIndex(nextIndex);
            this.list.ensureIndexIsVisible(nextIndex);
        }
    }

    protected void selectNextPossibleValue() {
        int si = this.list.getSelectedIndex();
        if (si < this.list.getModel().getSize() - 1) {
            int nextIndex = si + 1;
            this.list.setSelectedIndex(nextIndex);
            this.list.ensureIndexIsVisible(nextIndex);
        }
    }

    protected void selectPreviousPossibleValue() {
        int si = this.list.getSelectedIndex();
        if (si > 0) {
            int nextIndex = si - 1;
            this.list.setSelectedIndex(nextIndex);
            this.list.ensureIndexIsVisible(nextIndex);
        }
    }

    protected abstract class ShowingThread
    extends Thread {
        protected boolean isStopped = false;
        protected int delayTime;

        public ShowingThread(int delayTime) {
            this.delayTime = delayTime;
        }

        public void run() {
            CompletionType.this.hideAutocompletionPopup();
            if (!CompletionType.this.autocompletedtextComp.isShowing() || !CompletionType.this.autocompletedtextComp.isEnabled()) {
                return;
            }
            this.delay(this.delayTime);
            if (this.isStopped) {
                return;
            }
            this.showAutocompletionPopup();
        }

        public void done() {
            this.isStopped = true;
        }

        protected void delay(int miliseconds) {
            if (miliseconds > 0) {
                try {
                    Thread.sleep(miliseconds);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        abstract void showAutocompletionPopup();
    }
}

