/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleToolBarAction
extends MuAction {
    public ToggleToolBarAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.updateLabel(MuConfigurations.getPreferences().getVariable(MuPreference.TOOLBAR_VISIBLE, true));
    }

    private void updateLabel(boolean visible) {
        this.setLabel(Translator.get(visible ? "ToggleToolBar.hide" : "ToggleToolBar.show", new String[0]));
    }

    @Override
    public void performAction() {
        JPanel toolBarPanel = this.mainFrame.getToolBarPanel();
        boolean visible = !toolBarPanel.isVisible();
        MuConfigurations.getPreferences().setVariable(MuPreference.TOOLBAR_VISIBLE, visible);
        this.updateLabel(visible);
        toolBarPanel.setVisible(visible);
        this.mainFrame.validate();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "ToggleToolBar";
        }

        public ActionCategory getCategory() {
            return ActionCategories.VIEW;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return null;
        }

        public String getLabelKey() {
            return "ToggleToolBar.show";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new ToggleToolBarAction(mainFrame, properties);
        }
    }
}

