/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.commandbar.CommandBar;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleCommandBarAction
extends MuAction {
    public ToggleCommandBarAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.updateLabel(MuConfigurations.getPreferences().getVariable(MuPreference.COMMAND_BAR_VISIBLE, true));
    }

    private void updateLabel(boolean visible) {
        this.setLabel(Translator.get(visible ? "ToggleCommandBar.hide" : "ToggleCommandBar.show", new String[0]));
    }

    @Override
    public void performAction() {
        CommandBar commandBar = this.mainFrame.getCommandBar();
        boolean visible = !commandBar.isVisible();
        MuConfigurations.getPreferences().setVariable(MuPreference.COMMAND_BAR_VISIBLE, visible);
        this.updateLabel(visible);
        commandBar.setVisible(visible);
        this.mainFrame.validate();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "ToggleCommandBar";
        }

        public ActionCategory getCategory() {
            return ActionCategories.VIEW;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return null;
        }

        public String getLabelKey() {
            return "ToggleCommandBar.show";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new ToggleCommandBarAction(mainFrame, properties);
        }
    }
}

