/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.event.ActivePanelListener;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.Column;
import com.mucommander.ui.main.table.FileTable;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SortByAction
extends MuAction
implements ActivePanelListener,
TableColumnModelListener {
    protected Column column;

    public SortByAction(MainFrame mainFrame, Map<String, Object> properties, Column column) {
        super(mainFrame, properties);
        this.column = column;
        mainFrame.addActivePanelListener(this);
        mainFrame.getLeftPanel().getFileTable().getColumnModel().addColumnModelListener(this);
        mainFrame.getRightPanel().getFileTable().getColumnModel().addColumnModelListener(this);
        this.updateState(mainFrame.getActiveTable());
    }

    private void updateState(FileTable fileTable) {
        this.setEnabled(fileTable.isColumnVisible(this.column));
    }

    @Override
    public void performAction() {
        this.mainFrame.getActiveTable().sortBy(this.column);
    }

    @Override
    public void activePanelChanged(FolderPanel folderPanel) {
        this.updateState(folderPanel.getFileTable());
    }

    @Override
    public void columnAdded(TableColumnModelEvent event) {
        if (event.getFromIndex() == this.column.ordinal()) {
            this.setEnabled(true);
        }
    }

    @Override
    public void columnRemoved(TableColumnModelEvent event) {
        if (event.getFromIndex() == this.column.ordinal()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent event) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent event) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent event) {
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        private Column column;
        private KeyStroke defaultKeyStroke;

        public Descriptor(Column column, KeyStroke defaultKeyStroke) {
            this.column = column;
            this.defaultKeyStroke = defaultKeyStroke;
        }

        public String getId() {
            return this.column.getSortByColumnActionId();
        }

        public ActionCategory getCategory() {
            return ActionCategories.VIEW;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return this.defaultKeyStroke;
        }
    }
}

