/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractArchiveEntryFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.ParentFolderAction;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.main.MainFrame;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevealInDesktopAction
extends ParentFolderAction {
    public RevealInDesktopAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.setEnabled(DesktopManager.canOpenInFileManager());
    }

    @Override
    protected void toggleEnabledState() {
        AbstractFile abstractFile = this.mainFrame.getActiveTable().getCurrentFolder();
        this.setEnabled(abstractFile.getURL().getScheme().equals("file") && !abstractFile.isArchive() && !abstractFile.hasAncestor(AbstractArchiveEntryFile.class));
    }

    @Override
    public void performAction() {
        try {
            DesktopManager.openInFileManager(this.mainFrame.getActivePanel().getCurrentFolder());
        }
        catch (Exception e) {
            InformationDialog.showErrorDialog(this.mainFrame);
        }
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "RevealInDesktop";
        }

        public ActionCategory getCategory() {
            return ActionCategories.NAVIGATION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(76, 128);
        }

        public String getLabel() {
            return Translator.get(ActionProperties.getActionLabelKey("RevealInDesktop"), DesktopManager.canOpenInFileManager() ? DesktopManager.getFileManagerName() : Translator.get("file_manager", new String[0]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new RevealInDesktopAction(mainFrame, properties);
        }
    }
}

