/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.text.Translator;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.WindowManager;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecallWindowAction
extends MuAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecallWindowAction.class);
    private int windowNumber;

    public RecallWindowAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        Object windowNumberValue = this.getValue("window_number");
        if (windowNumberValue == null || !(windowNumberValue instanceof String)) {
            throw new IllegalArgumentException("window_number (" + windowNumberValue + ")");
        }
        this.windowNumber = Integer.parseInt((String)windowNumberValue);
        if (this.windowNumber <= 0) {
            throw new IllegalArgumentException("window_number (" + windowNumberValue + ")");
        }
    }

    public RecallWindowAction(MainFrame mainFrame, Map<String, Object> properties, int windowNumber) {
        super(mainFrame, properties);
        this.windowNumber = windowNumber;
        if (windowNumber <= 0) {
            throw new IllegalArgumentException("windowNumber (" + windowNumber + ")");
        }
    }

    @Override
    public void performAction() {
        List<MainFrame> mainFrames = WindowManager.getMainFrames();
        if (this.windowNumber <= 0 || this.windowNumber > mainFrames.size()) {
            LOGGER.debug("Window number " + this.windowNumber + " does not exist");
            return;
        }
        mainFrames.get(this.windowNumber - 1).toFront();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        private int windowNumber;

        public Descriptor() {
            this(-1);
        }

        protected Descriptor(int windowNumber) {
            this.windowNumber = windowNumber;
        }

        public String getId() {
            return "RecallWindow" + (this.windowNumber == -1 ? "" : "" + this.windowNumber);
        }

        public ActionCategory getCategory() {
            return ActionCategories.WINDOW;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            if (this.windowNumber <= 0 || this.windowNumber > 10) {
                return null;
            }
            return KeyStroke.getKeyStroke((int)Character.forDigit(this.windowNumber == 10 ? 0 : this.windowNumber, 10), 128);
        }

        public String getLabel() {
            return Translator.get(this.getLabelKey(), this.windowNumber == -1 ? "?" : "" + this.windowNumber);
        }

        public boolean isParameterized() {
            return this.windowNumber == -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new RecallWindowAction(mainFrame, properties);
        }
    }
}

