/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.AbstractFilenameFilter;
import com.mucommander.commons.file.filter.ExtensionFilenameFilter;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkExtensionAction
extends MuAction {
    public MarkExtensionAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
    }

    private String getExtension() {
        Object o = this.getValue("extension");
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    private boolean isCaseSensitive() {
        Object o = this.getValue("case_sensitive");
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return o.equals("true");
        }
        return false;
    }

    private FilenameFilter getFilter(AbstractFile file) {
        String ext = this.getExtension();
        if (ext == null) {
            if (file == null) {
                return null;
            }
            ext = file.getExtension();
            if (ext == null) {
                return new AbstractFilenameFilter(){

                    public boolean accept(String name) {
                        return AbstractFile.getExtension(name) == null;
                    }
                };
            }
        }
        ExtensionFilenameFilter filter = new ExtensionFilenameFilter("." + ext);
        filter.setCaseSensitive(this.isCaseSensitive());
        return filter;
    }

    @Override
    public void performAction() {
        FileTable fileTable = this.mainFrame.getActiveTable();
        FilenameFilter filter = this.getFilter(fileTable.getSelectedFile(false, true));
        if (filter == null) {
            return;
        }
        FileTableModel tableModel = fileTable.getFileTableModel();
        int rowCount = tableModel.getRowCount();
        boolean mark = !tableModel.isRowMarked(fileTable.getSelectedRow());
        for (int i = tableModel.getFirstMarkableRow(); i < rowCount; ++i) {
            if (!filter.accept(tableModel.getCachedFileAtRow(i))) continue;
            tableModel.setRowMarked(i, mark);
        }
        fileTable.repaint();
        fileTable.fireMarkedFilesChangedEvent();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "MarkExtension";
        }

        public ActionCategory getCategory() {
            return ActionCategories.SELECTION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(107, 64);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new MarkExtensionAction(mainFrame, properties);
        }
    }
}

