/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.filter.AndFileFilter;
import com.mucommander.commons.file.filter.FileOperationFilter;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.action.impl.SelectedFileAction;
import com.mucommander.ui.dialog.file.LocalCopyDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCopyAction
extends SelectedFileAction {
    public LocalCopyAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.setSelectedFileFilter(new AndFileFilter(new FileOperationFilter(FileOperation.READ_FILE), new FileOperationFilter(FileOperation.WRITE_FILE)));
    }

    @Override
    public void performAction() {
        FileTable activeTable = this.mainFrame.getActiveTable();
        AbstractFile selectedFile = activeTable.getSelectedFile(false, true);
        if (selectedFile != null) {
            new LocalCopyDialog(this.mainFrame, new FileSet(activeTable.getCurrentFolder(), selectedFile)).showDialog();
        }
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "LocalCopy";
        }

        public ActionCategory getCategory() {
            return null;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(116, 64);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new LocalCopyAction(mainFrame, properties);
        }
    }
}

