/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.helper.FocusRequester;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.LocationTextField;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusNextAction
extends MuAction {
    public FocusNextAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.setHonourNoEventsMode(false);
    }

    @Override
    public void performAction() {
        JComponent nextComponent;
        Component focusOwner = this.mainFrame.getFocusOwner();
        if (focusOwner == null) {
            return;
        }
        FolderPanel folderPanel = this.mainFrame.getActivePanel();
        FileTable fileTable = folderPanel.getFileTable();
        LocationTextField locationField = folderPanel.getLocationTextField();
        JTree tree = folderPanel.getFoldersTreePanel().getTree();
        if (focusOwner == locationField) {
            nextComponent = folderPanel.isTreeVisible() ? tree : fileTable;
        } else if (focusOwner == tree) {
            nextComponent = fileTable;
        } else if (focusOwner == fileTable) {
            nextComponent = locationField;
        } else {
            return;
        }
        FocusRequester.requestFocusInWindow(nextComponent);
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "FocusNext";
        }

        public ActionCategory getCategory() {
            return ActionCategories.NAVIGATION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(9, 128);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new FocusNextAction(mainFrame, properties);
        }
    }
}

