/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.event.ActivePanelListener;
import com.mucommander.ui.event.TableSelectionListener;
import com.mucommander.ui.main.FolderPanel;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileAction
extends MuAction
implements ActivePanelListener,
TableSelectionListener {
    protected FileFilter filter;

    public FileAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.init(mainFrame);
    }

    private void init(MainFrame mainFrame) {
        mainFrame.addActivePanelListener(this);
        mainFrame.getLeftPanel().getFileTable().addTableSelectionListener(this);
        mainFrame.getRightPanel().getFileTable().addTableSelectionListener(this);
        this.updateEnabledState(mainFrame.getActiveTable());
    }

    protected void updateEnabledState(FileTable fileTable) {
        this.setEnabled(this.getFileTableCondition(fileTable));
    }

    protected abstract boolean getFileTableCondition(FileTable var1);

    @Override
    public void selectedFileChanged(FileTable source) {
        if (source == this.mainFrame.getActiveTable()) {
            this.updateEnabledState(source);
        }
    }

    @Override
    public void markedFilesChanged(FileTable source) {
        if (source == this.mainFrame.getActiveTable()) {
            this.updateEnabledState(source);
        }
    }

    @Override
    public void activePanelChanged(FolderPanel folderPanel) {
        this.updateEnabledState(folderPanel.getFileTable());
    }
}

