/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.ui.action.AbstractActionDescriptor;
import com.mucommander.ui.action.ActionCategories;
import com.mucommander.ui.action.ActionCategory;
import com.mucommander.ui.action.ActionFactory;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.main.table.FileTableModel;
import java.util.Map;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareFoldersAction
extends MuAction {
    public CompareFoldersAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
    }

    @Override
    public void performAction() {
        int j;
        int fileIndex;
        String tempFileName;
        AbstractFile tempFile;
        int i;
        FileTable leftTable = this.mainFrame.getLeftPanel().getFileTable();
        FileTable rightTable = this.mainFrame.getRightPanel().getFileTable();
        FileTableModel leftTableModel = leftTable.getFileTableModel();
        FileTableModel rightTableModel = rightTable.getFileTableModel();
        int nbFilesLeft = leftTableModel.getFileCount();
        int nbFilesRight = rightTableModel.getFileCount();
        for (i = 0; i < nbFilesLeft; ++i) {
            tempFile = leftTableModel.getFileAt(i);
            if (tempFile.isDirectory()) continue;
            tempFileName = tempFile.getName();
            fileIndex = -1;
            for (j = 0; j < nbFilesRight; ++j) {
                if (!rightTableModel.getFileAt(j).getName().equals(tempFileName)) continue;
                fileIndex = j;
                break;
            }
            if (fileIndex != -1 && rightTableModel.getFileAt(fileIndex).getDate() >= tempFile.getDate()) continue;
            leftTableModel.setFileMarked(tempFile, true);
            leftTable.repaint();
        }
        for (i = 0; i < nbFilesRight; ++i) {
            tempFile = rightTableModel.getFileAt(i);
            if (tempFile.isDirectory()) continue;
            tempFileName = tempFile.getName();
            fileIndex = -1;
            for (j = 0; j < nbFilesLeft; ++j) {
                if (!leftTableModel.getFileAt(j).getName().equals(tempFileName)) continue;
                fileIndex = j;
                break;
            }
            if (fileIndex != -1 && leftTableModel.getFileAt(fileIndex).getDate() >= tempFile.getDate()) continue;
            rightTableModel.setFileMarked(tempFile, true);
            rightTable.repaint();
        }
        leftTable.fireMarkedFilesChangedEvent();
        rightTable.fireMarkedFilesChangedEvent();
    }

    public static class Descriptor
    extends AbstractActionDescriptor {
        public String getId() {
            return "CompareFolders";
        }

        public ActionCategory getCategory() {
            return ActionCategories.SELECTION;
        }

        public KeyStroke getDefaultAltKeyStroke() {
            return null;
        }

        public KeyStroke getDefaultKeyStroke() {
            return KeyStroke.getKeyStroke(77, 128);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements ActionFactory {
        @Override
        public MuAction createAction(MainFrame mainFrame, Map<String, Object> properties) {
            return new CompareFoldersAction(mainFrame, properties);
        }
    }
}

