/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action.impl;

import com.mucommander.command.Command;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.filter.AndFileFilter;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.FileOperationFilter;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.job.TempOpenWithJob;
import com.mucommander.process.ProcessRunner;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.impl.SelectedFileAction;
import com.mucommander.ui.dialog.InformationDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractViewerAction
extends SelectedFileAction {
    public AbstractViewerAction(MainFrame mainFrame, Map<String, Object> properties) {
        super(mainFrame, properties);
        this.setSelectedFileFilter(new AndFileFilter(new FileOperationFilter(FileOperation.READ_FILE), new AttributeFileFilter(0, true)));
    }

    @Override
    public synchronized void performAction() {
        AbstractFile abstractFile = this.mainFrame.getActiveTable().getSelectedFile(false, true);
        if (abstractFile != null) {
            Command command = this.getCustomCommand();
            if (command != null) {
                if (abstractFile.hasAncestor(LocalFile.class)) {
                    try {
                        ProcessRunner.execute(command.getTokens(abstractFile), abstractFile);
                    }
                    catch (Exception exception) {
                        InformationDialog.showErrorDialog(this.mainFrame);
                    }
                } else {
                    ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, Translator.get("copy_dialog.copying", new String[0]));
                    TempOpenWithJob tempOpenWithJob = new TempOpenWithJob(progressDialog, this.mainFrame, abstractFile, command);
                    progressDialog.start(tempOpenWithJob);
                }
            } else {
                this.performInternalAction(abstractFile);
            }
        }
    }

    protected abstract void performInternalAction(AbstractFile var1);

    protected abstract Command getCustomCommand();
}

