/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.RuntimeConstants;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.ui.action.ActionKeymap;
import com.mucommander.ui.action.ActionKeymapIO;
import com.mucommander.ui.action.ActionManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionKeymapReader
extends ActionKeymapIO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionKeymapReader.class);
    private HashMap<String, KeyStroke> primaryActionsReadKeymap;
    private HashMap<String, KeyStroke> alternateActionsReadKeymap;
    private AbstractFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActionKeymapReader(AbstractFile file) throws SAXException, IOException, ParserConfigurationException {
        this.file = file;
        InputStream in = null;
        try {
            in = new BackupInputStream(file);
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)this);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void processKeystrokeAttribute(String actionId, Attributes attributes) {
        String prevAssignedActionId;
        KeyStroke alternateKeyStroke = null;
        KeyStroke primaryKeyStroke = null;
        String keyStrokeString = attributes.getValue("keystroke");
        if (keyStrokeString != null) {
            primaryKeyStroke = KeyStroke.getKeyStroke(keyStrokeString);
            if (primaryKeyStroke == null) {
                LOGGER.info("Action keymap file contains a keystroke which could not be resolved: " + keyStrokeString);
            } else {
                prevAssignedActionId = ActionKeymap.getRegisteredActionIdForKeystroke(primaryKeyStroke);
                if (prevAssignedActionId != null && !prevAssignedActionId.equals(actionId)) {
                    LOGGER.debug("Canceling previous association of keystroke " + keyStrokeString + ", reassign it to action: " + actionId);
                }
            }
        }
        if ((keyStrokeString = attributes.getValue("alt_keystroke")) != null) {
            alternateKeyStroke = KeyStroke.getKeyStroke(keyStrokeString);
            if (alternateKeyStroke == null) {
                LOGGER.info("Action keymap file contains a keystroke which could not be resolved: " + keyStrokeString);
            } else {
                prevAssignedActionId = ActionKeymap.getRegisteredActionIdForKeystroke(alternateKeyStroke);
                if (prevAssignedActionId != null && !prevAssignedActionId.equals(actionId)) {
                    LOGGER.debug("Canceling previous association of keystroke " + keyStrokeString + ", reassign it to action: " + actionId);
                }
            }
        }
        if (primaryKeyStroke == null) {
            LOGGER.debug("Action \"" + actionId + "\" has an alternative shortcut with no primary shortcut, so the alternative shortcut become primary");
            this.primaryActionsReadKeymap.put(actionId, alternateKeyStroke);
            this.alternateActionsReadKeymap.put(actionId, null);
            ActionKeymapReader.setModified();
        } else {
            this.primaryActionsReadKeymap.put(actionId, primaryKeyStroke);
            this.alternateActionsReadKeymap.put(actionId, alternateKeyStroke);
        }
    }

    public HashMap<String, KeyStroke> getPrimaryActionsKeymap() {
        return this.primaryActionsReadKeymap;
    }

    public HashMap<String, KeyStroke> getAlternateActionsKeymap() {
        return this.alternateActionsReadKeymap;
    }

    @Override
    public void startDocument() {
        LOGGER.trace(this.file.getAbsolutePath() + " parsing started");
        this.primaryActionsReadKeymap = new HashMap();
        this.alternateActionsReadKeymap = new HashMap();
    }

    @Override
    public void endDocument() {
        LOGGER.trace(this.file.getAbsolutePath() + " parsing finished");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String fileVersion;
        if (qName.equals("action")) {
            String actionId = attributes.getValue("id");
            if (actionId == null) {
                String actionClassPath = attributes.getValue("class");
                if (actionClassPath == null) {
                    LOGGER.warn("Error in action keymap file: no 'class' or 'id' attribute specified in 'action' element");
                    return;
                }
                actionId = ActionManager.extrapolateId(actionClassPath);
            }
            if (!ActionManager.isActionExist(actionId)) {
                LOGGER.warn("Error in action keymap file: could not resolve action " + actionId);
                return;
            }
            this.processKeystrokeAttribute(actionId, attributes);
        } else if (qName.equals("keymap") && !RuntimeConstants.VERSION.equals(fileVersion = attributes.getValue("version"))) {
            ActionKeymapReader.setModified();
        }
    }
}

