/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.ui.action;

import com.mucommander.commons.file.util.ResourceLoader;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionDescriptor;
import com.mucommander.ui.icon.IconManager;
import javax.swing.ImageIcon;

public abstract class AbstractActionDescriptor
implements ActionDescriptor {
    public String getLabel() {
        String label = this.getStandardLabel();
        if (label != null) {
            return label;
        }
        return this.getLabelKey();
    }

    public ImageIcon getIcon() {
        return AbstractActionDescriptor.getStandardIcon(this.getId());
    }

    public String getTooltip() {
        return AbstractActionDescriptor.getStandardTooltip(this.getId());
    }

    public String getDescription() {
        String tooltip = this.getTooltip();
        if (tooltip == null) {
            return this.getLabel();
        }
        return tooltip;
    }

    public String getLabelKey() {
        return this.getId() + ".label";
    }

    public boolean isParameterized() {
        return false;
    }

    private String getStandardLabel() {
        String labelKey = this.getLabelKey();
        if (!Translator.hasValue(labelKey, true)) {
            return null;
        }
        return Translator.get(labelKey, new String[0]);
    }

    private static ImageIcon getStandardIcon(String actionId) {
        String iconPath = AbstractActionDescriptor.getStandardIconPath(actionId);
        if (ResourceLoader.getResourceAsURL(iconPath) == null) {
            return null;
        }
        return IconManager.getIcon(iconPath);
    }

    private static String getStandardIconPath(String actionId) {
        return IconManager.getIconSetFolder(1) + actionId + ".png";
    }

    private static String getStandardTooltip(String actionId) {
        String tooltipKey = AbstractActionDescriptor.getStandardTooltipKey(actionId);
        if (!Translator.hasValue(tooltipKey, true)) {
            return null;
        }
        return Translator.get(tooltipKey, new String[0]);
    }

    private static String getStandardTooltipKey(String actionId) {
        return actionId + ".tooltip";
    }
}

