/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.text;

import com.mucommander.commons.file.util.ResourceLoader;
import com.mucommander.commons.io.bom.BOMReader;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Translator.class);
    private static Map<String, String> dictionary;
    private static Map<String, String> defaultDictionary;
    private static List<String> availableLanguages;
    private static String language;

    private Translator() {
    }

    private static void setCurrentLanguage(List<String> availableLanguages) {
        String lang = MuConfigurations.getPreferences().getVariable(MuPreference.LANGUAGE);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
            LOGGER.info("Language not set in preferences, trying to match system's language (" + lang + ")");
        } else {
            LOGGER.info("Using language set in preferences: " + lang);
        }
        boolean containsLanguage = false;
        int nbAvailableLanguages = availableLanguages.size();
        for (int i = 0; i < nbAvailableLanguages; ++i) {
            if (!availableLanguages.get(i).equalsIgnoreCase(lang)) continue;
            containsLanguage = true;
            lang = availableLanguages.get(i);
            break;
        }
        if (containsLanguage) {
            language = lang;
            LOGGER.debug("Language " + lang + " is available.");
        } else {
            language = "EN";
            LOGGER.debug("Language " + lang + " is not available, falling back to default language " + "EN");
        }
        MuConfigurations.getPreferences().setVariable(MuPreference.LANGUAGE, language);
        LOGGER.debug("Current language has been set to " + language);
    }

    public static void loadDictionaryFile() throws IOException {
        Translator.loadDictionaryFile("/dictionary.txt");
    }

    public static void loadDictionaryFile(String filePath) throws IOException {
        String line;
        availableLanguages = new Vector<String>();
        dictionary = new Hashtable<String, String>();
        defaultDictionary = new Hashtable<String, String>();
        BufferedReader br = new BufferedReader(new BOMReader(ResourceLoader.getResourceAsStream(filePath)));
        while ((line = br.readLine()) != null) {
            if (line.trim().startsWith("#") || line.trim().equals("")) continue;
            StringTokenizer st = new StringTokenizer(line);
            try {
                String keyLC = st.nextToken(":").trim().toLowerCase();
                if (language == null && keyLC.equals("available_languages")) {
                    st = new StringTokenizer(st.nextToken(), ",\n");
                    while (st.hasMoreTokens()) {
                        availableLanguages.add(st.nextToken().trim());
                    }
                    LOGGER.debug("Available languages= " + availableLanguages);
                    Translator.setCurrentLanguage(availableLanguages);
                    continue;
                }
                String lang = st.nextToken().trim();
                String text = st.nextToken("\n");
                text = text.substring(1, text.length());
                int pos = 0;
                while ((pos = text.indexOf("\\n", pos)) != -1) {
                    text = text.substring(0, pos) + "\n" + text.substring(pos + 2, text.length());
                }
                pos = 0;
                while ((pos = text.indexOf("\\u", pos)) != -1) {
                    text = text.substring(0, pos) + (char)Integer.parseInt(text.substring(pos + 2, pos + 6), 16) + text.substring(pos + 6, text.length());
                }
                if (lang.equalsIgnoreCase(language)) {
                    dictionary.put(keyLC, text);
                    defaultDictionary.remove(keyLC);
                    continue;
                }
                if (!lang.equalsIgnoreCase("EN") || dictionary.get(keyLC) != null) continue;
                defaultDictionary.put(keyLC, text);
            }
            catch (Exception e) {
                LOGGER.info("error in line " + line + " (" + e + ")");
                throw new IOException("Syntax error in line " + line);
            }
        }
        br.close();
    }

    public static String[] getAvailableLanguages() {
        String[] languages = availableLanguages.toArray(new String[availableLanguages.size()]);
        Arrays.sort(languages, String.CASE_INSENSITIVE_ORDER);
        return languages;
    }

    public static boolean hasValue(String key, boolean useDefaultLanguage) {
        return dictionary.get(key.toLowerCase()) != null || useDefaultLanguage && defaultDictionary.get(key.toLowerCase()) != null;
    }

    public static String get(String key, String ... paramValues) {
        int pos;
        String text = dictionary.get(key.toLowerCase());
        if (text == null) {
            text = defaultDictionary.get(key.toLowerCase());
            if (text == null) {
                LOGGER.debug("No value for " + key + ", returning key");
                return key;
            }
            LOGGER.debug("No value for " + key + " in language " + language + ", using " + "EN" + " value");
        }
        if (paramValues != null) {
            pos = -1;
            for (int i = 0; i < paramValues.length; ++i) {
                while (++pos < text.length() - 1 && (pos = text.indexOf("%" + (i + 1), pos)) != -1) {
                    text = text.substring(0, pos) + paramValues[i] + text.substring(pos + 2, text.length());
                }
            }
        }
        pos = 0;
        while ((pos = text.indexOf("$[", pos)) != -1) {
            int pos2 = text.indexOf("]", pos + 1);
            String variable = text.substring(pos + 2, pos2);
            text = text.substring(0, pos) + Translator.get(variable, paramValues) + text.substring(pos2 + 1, text.length());
        }
        return text;
    }
}

