/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.text;

import com.mucommander.text.Translator;

public class DurationFormat {
    private static final String INFINITE = Translator.get("duration.infinite", new String[0]);

    public static String format(long durationMs) {
        if (durationMs / 1000L > Integer.MAX_VALUE) {
            return INFINITE;
        }
        int remainderSec = Math.round((float)durationMs / 1000.0f);
        String s = "";
        String[] keys = new String[]{"duration.years", "duration.months", "duration.days", "duration.hours", "duration.minutes"};
        int[] seconds = new int[]{31104000, 2592000, 86400, 3600, 60};
        for (int i = 0; i < 5; ++i) {
            int n = remainderSec / seconds[i];
            if (n <= 0) continue;
            if (!s.equals("")) {
                s = s + " ";
            }
            s = s + Translator.get(keys[i], "" + n);
            remainderSec %= seconds[i];
        }
        if (remainderSec > 0 || s.equals("")) {
            s = remainderSec == 0 ? "<" + Translator.get("duration.seconds", "1") : s + (s.equals("") ? "" : " ") + Translator.get("duration.seconds", "" + remainderSec);
        }
        return s;
    }

    public static String getInfiniteSymbol() {
        return INFINITE;
    }
}

