/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.text;

import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CustomDateFormat
implements ConfigurationListener {
    private static CustomDateFormat singleton;
    private static SimpleDateFormat dateFormat;

    private CustomDateFormat() {
    }

    public static void init() {
        singleton = new CustomDateFormat();
        MuConfigurations.addPreferencesListener(singleton);
        dateFormat = CustomDateFormat.createDateFormat();
    }

    public static String replaceDateSeparator(String dateFormatString, String separator) {
        int pos2;
        if (separator == null || separator.equals("/")) {
            return dateFormatString;
        }
        StringBuilder dateFormatStringSB = new StringBuilder();
        int pos1 = 0;
        while ((pos2 = dateFormatString.indexOf(47, pos1)) > -1) {
            dateFormatStringSB.append(dateFormatString.substring(pos1, pos2));
            dateFormatStringSB.append(separator);
            pos1 = pos2 + 1;
        }
        dateFormatStringSB.append(dateFormatString.substring(pos1, dateFormatString.length()));
        return dateFormatStringSB.toString();
    }

    public static String getDateFormatString() {
        return CustomDateFormat.replaceDateSeparator(MuConfigurations.getPreferences().getVariable(MuPreference.DATE_FORMAT, "MM/dd/yy"), MuConfigurations.getPreferences().getVariable(MuPreference.DATE_SEPARATOR, "/")) + " " + MuConfigurations.getPreferences().getVariable(MuPreference.TIME_FORMAT, "hh:mm a");
    }

    public static synchronized void updateDateFormat() {
        dateFormat = CustomDateFormat.createDateFormat();
    }

    private static SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat(CustomDateFormat.getDateFormatString());
    }

    public static synchronized String format(Date date) {
        return dateFormat.format(date);
    }

    public void configurationChanged(ConfigurationEvent event) {
        String var = event.getVariable();
        if (var.equals("time_format") || var.equals("date_format") || var.equals("date_separator")) {
            CustomDateFormat.updateDateFormat();
        }
    }
}

