/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.shell;

import com.mucommander.PlatformManager;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.io.backup.BackupOutputStream;
import com.mucommander.shell.ShellHistoryListener;
import com.mucommander.shell.ShellHistoryReader;
import com.mucommander.shell.ShellHistoryWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellHistoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellHistoryManager.class);
    private static WeakHashMap<ShellHistoryListener, ?> listeners;
    private static String[] history;
    private static int historyStart;
    private static int historyEnd;
    private static AbstractFile historyFile;

    private ShellHistoryManager() {
    }

    public static void addListener(ShellHistoryListener listener) {
        listeners.put(listener, null);
    }

    private static void triggerEvent(String command) {
        for (ShellHistoryListener listener : listeners.keySet()) {
            listener.historyChanged(command);
        }
    }

    public static void clear() {
        historyStart = 0;
        historyEnd = 0;
        for (ShellHistoryListener listener : listeners.keySet()) {
            listener.historyCleared();
        }
    }

    public static Iterator<String> getHistoryIterator() {
        return new HistoryIterator();
    }

    public static void add(String command) {
        int lastIndex;
        if (command.trim().equals("")) {
            return;
        }
        if (historyEnd != historyStart && command.equals(history[lastIndex = historyEnd == 0 ? history.length - 1 : historyEnd - 1])) {
            return;
        }
        LOGGER.debug("Adding  " + command + " to shell history.");
        ShellHistoryManager.history[ShellHistoryManager.historyEnd] = command;
        if (++historyEnd == history.length) {
            historyEnd = 0;
        }
        if (historyEnd == historyStart && ++historyStart == history.length) {
            historyStart = 0;
        }
        ShellHistoryManager.triggerEvent(command);
    }

    public static void setHistoryFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            ShellHistoryManager.setHistoryFile(new File(path));
        } else {
            ShellHistoryManager.setHistoryFile(file);
        }
    }

    public static void setHistoryFile(File file) throws FileNotFoundException {
        ShellHistoryManager.setHistoryFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    public static void setHistoryFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file.getAbsolutePath());
        }
        historyFile = file;
    }

    public static AbstractFile getHistoryFile() throws IOException {
        if (historyFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("shell_history.xml");
        }
        return historyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHistory() throws IOException {
        BackupOutputStream out = null;
        try {
            out = new BackupOutputStream(ShellHistoryManager.getHistoryFile());
            ShellHistoryWriter.write(out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadHistory() throws Exception {
        BackupInputStream in = null;
        try {
            in = new BackupInputStream(ShellHistoryManager.getHistoryFile());
            ShellHistoryReader.read(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static /* synthetic */ int access$000() {
        return historyStart;
    }

    static {
        history = new String[MuConfigurations.getPreferences().getVariable(MuPreference.SHELL_HISTORY_SIZE, 100)];
        listeners = new WeakHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HistoryIterator
    implements Iterator<String> {
        private int index = ShellHistoryManager.access$000();

        @Override
        public boolean hasNext() {
            return this.index != historyEnd;
        }

        @Override
        public String next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String value = history[this.index];
            if (++this.index == history.length) {
                this.index = 0;
            }
            return value;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

