/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.shell;

import com.mucommander.commons.io.EncodingDetector;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.process.ProcessListener;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

class ShellEncodingListener
implements ProcessListener {
    private static ByteArrayOutputStream out = new ByteArrayOutputStream();

    ShellEncodingListener() {
    }

    public synchronized void processDied(int returnValue) {
        if (out == null) {
            return;
        }
        String encoding = EncodingDetector.detectEncoding(out.toByteArray());
        if (encoding == null) {
            return;
        }
        if (Charset.isSupported(encoding)) {
            String oldEncoding = MuConfigurations.getPreferences().getVariable(MuPreference.SHELL_ENCODING);
            if (oldEncoding == null || !encoding.equals(oldEncoding)) {
                MuConfigurations.getPreferences().setVariable(MuPreference.SHELL_ENCODING, encoding);
            }
            if (out.size() >= 4096) {
                out = null;
            }
        }
    }

    public void processOutput(String output) {
    }

    public synchronized void processOutput(byte[] buff, int from, int len) {
        if (out != null && (len = Math.min(len, 4096 - out.size())) > 0) {
            out.write(buff, from, len);
        }
    }
}

