/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.process;

import com.mucommander.process.AbstractProcess;
import com.mucommander.process.ProcessListener;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessOutputMonitor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessOutputMonitor.class);
    private InputStream in;
    private String encoding;
    private ProcessListener listener;
    private AbstractProcess process;
    private boolean monitor;

    public ProcessOutputMonitor(InputStream in, String encoding, ProcessListener listener) {
        this.listener = listener;
        this.in = in;
        this.monitor = true;
        this.encoding = encoding;
    }

    public ProcessOutputMonitor(InputStream in, String encoding, ProcessListener listener, AbstractProcess process) {
        this(in, encoding, listener);
        this.process = process;
    }

    public void run() {
        byte[] buffer = new byte[512];
        try {
            int read;
            while (this.monitor && (read = this.in.read(buffer, 0, buffer.length)) != -1) {
                if (this.listener == null) continue;
                this.listener.processOutput(buffer, 0, read);
                if (this.encoding == null) {
                    this.listener.processOutput(new String(buffer, 0, read));
                    continue;
                }
                this.listener.processOutput(new String(buffer, 0, read, this.encoding));
            }
        }
        catch (IOException e) {
            LOGGER.debug("IOException thrown while monitoring process", e);
        }
        LOGGER.debug("Process output stream emptied, closing");
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug("IOException thrown while closing process stream", e);
        }
        if (this.process != null) {
            try {
                this.process.waitFor();
            }
            catch (Exception e) {
                LOGGER.debug("Caught Exception while waiting for process " + this.process, e);
            }
            if (this.monitor && this.listener != null) {
                this.listener.processDied(this.process.exitValue());
            }
        }
    }

    public void stopMonitoring() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
        this.monitor = false;
    }
}

