/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.process;

import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.process.AbstractProcess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalProcess
extends AbstractProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalProcess.class);
    private Process process;

    public LocalProcess(String[] tokens, File dir) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(tokens);
        pb.directory(dir);
        pb.redirectErrorStream(true);
        this.process = pb.start();
        if (this.process == null) {
            throw new IOException();
        }
    }

    public boolean usesMergedStreams() {
        return JavaVersions.JAVA_1_5.isCurrentOrHigher();
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    protected void destroyProcess() {
        this.process.destroy();
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public InputStream getErrorStream() throws IOException {
        if (this.usesMergedStreams()) {
            LOGGER.debug("Tried to access the error stream of a merged streams process.");
            throw new IOException();
        }
        return this.process.getErrorStream();
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }
}

