/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.process;

import com.mucommander.process.ProcessListener;
import com.mucommander.process.ProcessOutputMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcess.class);
    private ProcessOutputMonitor stdoutMonitor;
    private ProcessOutputMonitor stderrMonitor;

    public final void destroy() {
        new Thread(){

            public void run() {
                LOGGER.debug("Destroying process...");
                AbstractProcess.this.stdoutMonitor.stopMonitoring();
                if (AbstractProcess.this.stderrMonitor != null) {
                    AbstractProcess.this.stderrMonitor.stopMonitoring();
                }
                try {
                    AbstractProcess.this.destroyProcess();
                }
                catch (IOException e) {
                    LOGGER.debug("IOException caught", e);
                }
            }
        }.start();
    }

    final void startMonitoring(ProcessListener listener, String encoding) throws IOException {
        if (this.usesMergedStreams()) {
            LOGGER.debug("Starting process merged output monitor...");
            this.stdoutMonitor = new ProcessOutputMonitor(this.getInputStream(), encoding, listener, this);
            new Thread((Runnable)this.stdoutMonitor, "Process sdtout/stderr monitor").start();
        } else {
            LOGGER.debug("Starting process stdout and stderr monitors...");
            this.stdoutMonitor = new ProcessOutputMonitor(this.getInputStream(), encoding, listener, this);
            new Thread((Runnable)this.stdoutMonitor, "Process stdout monitor").start();
            this.stderrMonitor = new ProcessOutputMonitor(this.getErrorStream(), encoding, listener);
            new Thread((Runnable)this.stderrMonitor, "Process stderr monitor").start();
        }
    }

    public abstract boolean usesMergedStreams();

    public abstract int waitFor() throws InterruptedException, IOException;

    protected abstract void destroyProcess() throws IOException;

    public abstract int exitValue();

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract InputStream getErrorStream() throws IOException;
}

