/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.command.Command;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.TempCopyJob;
import com.mucommander.process.ProcessRunner;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempOpenWithJob
extends TempCopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempOpenWithJob.class);
    private Command command;
    private FileSet filesToOpen;
    private FileSet tempFiles;

    public TempOpenWithJob(ProgressDialog progressDialog, MainFrame mainFrame, AbstractFile fileToOpen, Command command) {
        this(progressDialog, mainFrame, new FileSet(fileToOpen.getParent(), fileToOpen), command);
    }

    public TempOpenWithJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet filesToOpen, Command command) {
        super(progressDialog, mainFrame, filesToOpen);
        this.command = command;
        this.filesToOpen = filesToOpen;
        this.tempFiles = new FileSet(this.baseDestFolder);
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (!super.processFile(file, recurseParams)) {
            return false;
        }
        if (this.filesToOpen.indexOf(file) != -1) {
            if (!this.currentDestFile.isDirectory()) {
                try {
                    if (this.currentDestFile.getChangeablePermissions().getBitValue(2, 2)) {
                        this.currentDestFile.changePermission(2, 2, false);
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exeception while changing permissions of " + this.currentDestFile, e);
                    return false;
                }
            }
            this.tempFiles.add(this.currentDestFile);
        }
        return true;
    }

    protected void jobCompleted() {
        super.jobCompleted();
        try {
            ProcessRunner.execute(this.command.getTokens(this.tempFiles), this.baseDestFolder);
        }
        catch (Exception e) {
            LOGGER.debug("Caught exception executing " + this.command + " " + this.tempFiles, e);
        }
    }
}

