/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.TempCopyJob;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.quicklist.RecentExecutedFilesQL;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempExecJob
extends TempCopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempExecJob.class);
    private FileSet filesToExecute;

    public TempExecJob(ProgressDialog progressDialog, MainFrame mainFrame, AbstractFile fileToExecute) {
        this(progressDialog, mainFrame, new FileSet(fileToExecute.getParent(), fileToExecute));
    }

    public TempExecJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet filesToExecute) {
        super(progressDialog, mainFrame, filesToExecute);
        this.filesToExecute = filesToExecute;
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (!super.processFile(file, recurseParams)) {
            return false;
        }
        if (this.filesToExecute.indexOf(file) != -1) {
            if (!this.currentDestFile.isDirectory()) {
                try {
                    if (this.currentDestFile.getChangeablePermissions().getBitValue(2, 2)) {
                        this.currentDestFile.changePermission(2, 2, false);
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Caught exeception while changing permissions of " + this.currentDestFile, e);
                    return false;
                }
            }
            try {
                DesktopManager.open(this.currentDestFile);
                RecentExecutedFilesQL.addFile(file);
            }
            catch (Exception e) {
                LOGGER.debug("Caught exeception while opening " + this.currentDestFile, e);
                return false;
            }
        }
        return true;
    }
}

