/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.DummyFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.ChecksumInputStream;
import com.mucommander.commons.io.FileTransferException;
import com.mucommander.commons.io.StreamUtils;
import com.mucommander.job.AbstractCopyJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.ActionProperties;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitFileJob
extends AbstractCopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitFileJob.class);
    private long partSize;
    private AbstractFile sourceFile;
    private InputStream origFileStream;
    private AbstractFile destFolder;
    private long sizeLeft;
    private boolean recalculateCRC = false;

    public SplitFileJob(ProgressDialog progressDialog, MainFrame mainFrame, AbstractFile file, AbstractFile destFolder, long partSize, int parts) {
        super(progressDialog, mainFrame, new FileSet(), destFolder, null, -1);
        this.partSize = partSize;
        this.setNbFiles(parts);
        this.sourceFile = file;
        this.destFolder = destFolder;
        this.errorDialogTitle = Translator.get("split_file_dialog.error_title", new String[0]);
        this.createInputStream();
        this.sizeLeft = this.sourceFile.getSize();
        for (int i = 1; i <= parts; ++i) {
            this.addDummyFile(i, Math.min(partSize, this.sizeLeft));
            this.sizeLeft -= partSize;
        }
        this.sizeLeft = this.sourceFile.getSize();
    }

    private void addDummyFile(int i, long size) {
        String num = i < 10 ? "00" + Integer.toString(i) : (i < 100 ? "0" + Integer.toString(i) : Integer.toString(i));
        FileURL childURL = (FileURL)this.destFolder.getURL().clone();
        childURL.setPath(this.destFolder.addTrailingSeparator(childURL.getPath()) + this.sourceFile.getName() + "." + num);
        DummyDestFile fileHolder = new DummyDestFile(childURL, size);
        this.files.add(fileHolder);
    }

    protected void jobStarted() {
        super.jobStarted();
        this.createInputStream();
    }

    private void createInputStream() {
        try {
            this.origFileStream = this.sourceFile.getInputStream();
        }
        catch (IOException e) {
            LOGGER.debug("Caught exception", e);
            this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_transferring", this.sourceFile.getName()), new String[]{CANCEL_TEXT}, new int[]{3});
            this.setState(3);
            return;
        }
        this.origFileStream = this.setCurrentInputStream(this.origFileStream);
        if (this.isIntegrityCheckEnabled()) {
            try {
                this.origFileStream = new ChecksumInputStream(this.origFileStream, MessageDigest.getInstance("CRC32"));
            }
            catch (NoSuchAlgorithmException e) {
                this.setIntegrityCheckEnabled(false);
                LOGGER.debug("Caught exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.getState() == 3) {
            return false;
        }
        destFile = this.createDestinationFile(this.baseDestFolder, file.getName());
        if (destFile == null) {
            return false;
        }
        if ((destFile = this.checkForCollision(this.sourceFile, this.baseDestFolder, destFile, false)) == null) {
            return false;
        }
        out = null;
        try {
            out = destFile.getOutputStream();
            try {
                written = StreamUtils.copyStream(this.origFileStream, out, BufferPool.getDefaultBufferSize(), this.partSize);
                this.sizeLeft -= written;
                ** GOTO lbl38
            }
            catch (FileTransferException e) {
                if (e.getReason() != 5) ** GOTO lbl37
                this.recalculateCRC = true;
                out.close();
                out = null;
                this.sizeLeft -= e.getBytesWritten();
                this.showErrorDialog(ActionProperties.getActionLabel("SplitFile"), Translator.get("split_file_dialog.insert_new_media", new String[0]), new String[]{SplitFileJob.OK_TEXT, SplitFileJob.CANCEL_TEXT}, new int[]{5, 3});
                if (this.getState() == 3) {
                    var6_11 = false;
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return var6_11;
                }
                try {
                    block30: {
                        if (this.sizeLeft > 0L && this.getCurrentFileIndex() == this.getNbFiles() - 1) {
                            this.setNbFiles(this.getNbFiles() + 1);
                            this.addDummyFile(this.getNbFiles(), this.sizeLeft);
                        }
                        break block30;
lbl37:
                        // 1 sources

                        throw e;
                    }
                    if (destFile.isFileOperationSupported(FileOperation.CHANGE_DATE)) {
                        try {
                            destFile.changeDate(this.sourceFile.getDate());
                        }
                        catch (IOException e) {
                            SplitFileJob.LOGGER.debug("failed to change date of " + destFile, e);
                        }
                    }
                    if (destFile.isFileOperationSupported(FileOperation.CHANGE_PERMISSION)) {
                        try {
                            destFile.importPermissions(this.sourceFile, FilePermissions.DEFAULT_FILE_PERMISSIONS);
                        }
                        catch (IOException e) {
                            SplitFileJob.LOGGER.debug("failed to import " + this.sourceFile + " permissions into " + destFile, e);
                        }
                    }
                }
                catch (IOException e) {
                    SplitFileJob.LOGGER.debug("Caught exception", e);
                    this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_transferring", new String[]{destFile.getName()}), new String[]{SplitFileJob.CANCEL_TEXT}, new int[]{3});
                    var6_12 = false;
                    return var6_12;
                }
                catch (Throwable var8_15) {
                    throw var8_15;
                }
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e2) {}
        }
        return true;
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.baseDestFolder.isParentOf(folder);
    }

    protected void jobCompleted() {
        if (this.isIntegrityCheckEnabled() && this.origFileStream != null && this.origFileStream instanceof ChecksumInputStream) {
            String crcFileName = this.sourceFile.getName() + ".sfv";
            try {
                String sourceChecksum;
                if (this.recalculateCRC) {
                    this.origFileStream = this.sourceFile.getInputStream();
                    sourceChecksum = AbstractFile.calculateChecksum(this.origFileStream, MessageDigest.getInstance("CRC32"));
                    this.origFileStream.close();
                } else {
                    sourceChecksum = ((ChecksumInputStream)this.origFileStream).getChecksumString();
                }
                AbstractFile crcFile = this.baseDestFolder.getDirectChild(crcFileName);
                OutputStream crcStream = crcFile.getOutputStream();
                String line = this.sourceFile.getName() + " " + sourceChecksum;
                crcStream.write(line.getBytes("utf-8"));
                crcStream.close();
            }
            catch (Exception e) {
                LOGGER.debug("Caught exception", e);
                this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_transferring", crcFileName), new String[]{CANCEL_TEXT}, new int[]{3});
            }
        }
        super.jobCompleted();
    }

    private static class DummyDestFile
    extends DummyFile {
        private long size;

        public DummyDestFile(FileURL url, long size) {
            super(url);
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }
    }
}

