/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.mucommander.job.FileCollisionChecker;
import com.mucommander.job.FileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.FileCollisionDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkdirJob
extends FileJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(MkdirJob.class);
    private AbstractFile destFolder;
    private boolean mkfileMode;
    private long allocateSpace;

    public MkdirJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet fileSet) {
        super(progressDialog, mainFrame, fileSet);
        this.destFolder = fileSet.getBaseFolder();
        this.mkfileMode = false;
        this.setAutoUnmark(false);
    }

    public MkdirJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet fileSet, long allocateSpace) {
        super(progressDialog, mainFrame, fileSet);
        this.destFolder = fileSet.getBaseFolder();
        this.mkfileMode = true;
        this.allocateSpace = allocateSpace;
        this.setAutoUnmark(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFile(AbstractFile file, Object recurseParams) {
        if (this.getState() == 3) {
            return false;
        }
        while (true) {
            try {
                LOGGER.debug("Creating " + file);
                int collision = FileCollisionChecker.checkForCollision(null, file);
                if (collision != 0) {
                    int choice = this.waitForUserResponse(new FileCollisionDialog((Frame)this.getMainFrame(), (Component)this.getMainFrame(), collision, null, file, false, false));
                    if (choice == 2) {
                        file.delete();
                    } else {
                        this.interrupt();
                        return false;
                    }
                }
                if (this.mkfileMode) {
                    if (this.allocateSpace == -1L) {
                        file.mkfile();
                    } else {
                        OutputStream mkfileOut = null;
                        try {
                            if (file.isFileOperationSupported(FileOperation.RANDOM_WRITE_FILE)) {
                                mkfileOut = file.getRandomAccessOutputStream();
                                ((RandomAccessOutputStream)mkfileOut).setLength(this.allocateSpace);
                            }
                            mkfileOut = file.getOutputStream();
                            byte[] buffer = BufferPool.getByteArray();
                            int bufferSize = buffer.length;
                            try {
                                int nbWrite;
                                for (long remaining = this.allocateSpace; remaining > 0L && this.getState() != 3; remaining -= (long)nbWrite) {
                                    nbWrite = (int)(remaining > (long)bufferSize ? (long)bufferSize : remaining);
                                    mkfileOut.write(buffer, 0, nbWrite);
                                }
                            }
                            finally {
                                BufferPool.releaseByteArray(buffer);
                            }
                        }
                        finally {
                            if (mkfileOut != null) {
                                try {
                                    mkfileOut.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                } else {
                    file.mkdir();
                }
                file = FileFactory.getFile(file.getURL());
                this.selectFileWhenFinished(file);
                return true;
            }
            catch (IOException e) {
                if (this.mkfileMode && this.getState() == 3) {
                    return false;
                }
                LOGGER.debug("IOException caught", e);
                int action = this.showErrorDialog(Translator.get("error", new String[0]), Translator.get(this.mkfileMode ? "cannot_write_file" : "cannot_create_folder", file.getAbsolutePath()), new String[]{RETRY_TEXT, CANCEL_TEXT}, new int[]{2, 3});
                if (action == 2) continue;
                return false;
            }
            break;
        }
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.destFolder.equalsCanonical(folder);
    }

    public String getStatusString() {
        return Translator.get("creating_file", this.getCurrentFilename());
    }
}

