/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.CachedFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.FileJobListener;
import com.mucommander.job.progress.JobProgress;
import com.mucommander.job.ui.DialogResult;
import com.mucommander.job.ui.UserInputHelper;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.QuestionDialog;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import com.mucommander.ui.main.table.FileTable;
import com.mucommander.ui.notifier.AbstractNotifier;
import com.mucommander.ui.notifier.NotificationType;
import java.awt.Component;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileJob
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileJob.class);
    private Thread jobThread;
    private final Object pauseLock = new Object();
    private long startDate;
    private long endDate;
    private long pausedTime;
    private long pauseStartDate;
    private ProgressDialog progressDialog;
    private MainFrame mainFrame;
    private AbstractFile baseSourceFolder;
    protected FileSet files;
    private int nbFiles;
    private int currentFileIndex = -1;
    private AbstractFile currentFile;
    private String currentFilename = "";
    private boolean autoUnmark = true;
    private AbstractFile fileToSelect;
    private int jobState = 0;
    private WeakHashMap<FileJobListener, ?> listeners = new WeakHashMap();
    private JobProgress jobProgress;
    private boolean autoSkipErrors;
    protected static final String SKIP_TEXT = Translator.get("skip", new String[0]);
    protected static final String SKIP_ALL_TEXT = Translator.get("skip_all", new String[0]);
    protected static final String RETRY_TEXT = Translator.get("retry", new String[0]);
    protected static final String CANCEL_TEXT = Translator.get("cancel", new String[0]);
    protected static final String APPEND_TEXT = Translator.get("resume", new String[0]);
    protected static final String OK_TEXT = Translator.get("ok", new String[0]);

    public FileJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files) {
        this(mainFrame, files);
        this.progressDialog = progressDialog;
    }

    public FileJob(MainFrame mainFrame, FileSet files) {
        this.mainFrame = mainFrame;
        this.files = files;
        this.nbFiles = files.size();
        this.baseSourceFolder = files.getBaseFolder();
        for (int i = 0; i < this.nbFiles; ++i) {
            AbstractFile tempFile = (AbstractFile)files.elementAt(i);
            files.setElementAt(tempFile instanceof CachedFile ? tempFile : new CachedFile(tempFile, true), i);
        }
        if (this.baseSourceFolder != null) {
            this.baseSourceFolder = this.getBaseSourceFolder() instanceof CachedFile ? this.getBaseSourceFolder() : new CachedFile(this.getBaseSourceFolder(), true);
        }
        this.jobProgress = new JobProgress(this);
    }

    public void setAutoUnmark(boolean autoUnmark) {
        this.autoUnmark = autoUnmark;
    }

    public void setAutoSkipErrors(boolean autoSkipErrors) {
        this.autoSkipErrors = autoSkipErrors;
    }

    protected void selectFileWhenFinished(AbstractFile file) {
        this.fileToSelect = file;
    }

    public void start() {
        if (this.getState() != 0) {
            return;
        }
        this.getMainFrame().getLeftPanel().getFolderChangeMonitor().setPaused(true);
        this.getMainFrame().getRightPanel().getFolderChangeMonitor().setPaused(true);
        this.setState(1);
        this.startDate = System.currentTimeMillis();
        this.jobThread = new Thread((Runnable)this, this.getClass().getName());
        this.jobThread.start();
    }

    protected ProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    protected MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public int getState() {
        return this.jobState;
    }

    protected void setState(int jobState) {
        int oldState = this.jobState;
        this.jobState = jobState;
        for (FileJobListener listener : this.listeners.keySet()) {
            listener.jobStateChanged(this, oldState, jobState);
        }
    }

    public void addFileJobListener(FileJobListener listener) {
        this.listeners.put(listener, null);
    }

    public void removeFileJobListener(FileJobListener listener) {
        this.listeners.remove(listener);
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public long getPauseStartDate() {
        return this.pauseStartDate;
    }

    private void setPauseStartDate() {
        this.pauseStartDate = System.currentTimeMillis();
    }

    public long getPausedTime() {
        return this.pausedTime;
    }

    private void calcPausedTime() {
        this.pausedTime += System.currentTimeMillis() - this.getPauseStartDate();
    }

    public long getEffectiveJobTime() {
        if (this.getStartDate() == 0L) {
            return 0L;
        }
        return (this.getEndDate() == 0L ? System.currentTimeMillis() : this.getEndDate()) - this.getStartDate() - this.getPausedTime();
    }

    public void interrupt() {
        int state = this.getState();
        if (state == 3 || state == 4) {
            return;
        }
        if (state == 2) {
            this.setPaused(false);
        }
        this.setState(3);
        this.stop();
    }

    private void stop() {
        if (this.jobThread == null) {
            return;
        }
        this.jobThread = null;
        this.endDate = System.currentTimeMillis();
        this.jobStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        Object object = this.pauseLock;
        synchronized (object) {
            if (!paused && this.getState() == 2) {
                this.calcPausedTime();
                this.jobResumed();
                this.pauseLock.notify();
                this.setState(1);
            } else if (paused && this.getState() != 2 && this.getState() != 3 && this.getState() != 4) {
                this.setPauseStartDate();
                this.jobPaused();
                this.setState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextFile(AbstractFile file) {
        this.setCurrentFile(file);
        Object object = this.pauseLock;
        synchronized (object) {
            while (this.getState() == 2) {
                try {
                    this.pauseLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected String getCurrentFilename() {
        return this.currentFilename;
    }

    protected void jobStarted() {
        LOGGER.debug("called");
    }

    protected void jobCompleted() {
        LOGGER.debug("called");
        if (AbstractNotifier.isAvailable() && AbstractNotifier.getNotifier().isEnabled()) {
            AbstractNotifier.getNotifier().displayBackgroundNotification(NotificationType.JOB_COMPLETED, this.getProgressDialog() == null ? "" : this.getProgressDialog().getTitle(), Translator.get("progress_dialog.job_finished", new String[0]));
        }
    }

    protected void jobPaused() {
        LOGGER.debug("called");
    }

    protected void jobResumed() {
        LOGGER.debug("called");
    }

    protected void jobStopped() {
        LOGGER.debug("called");
    }

    protected int showErrorDialog(String title, String message) {
        String[] actionTexts = new String[]{SKIP_TEXT, SKIP_ALL_TEXT, RETRY_TEXT, CANCEL_TEXT};
        int[] actionValues = new int[]{0, 1, 2, 3};
        return this.showErrorDialog(title, message, actionTexts, actionValues);
    }

    protected int showErrorDialog(String title, String message, String[] actionTexts, int[] actionValues) {
        QuestionDialog dialog;
        int userChoice;
        if (this.autoSkipErrors) {
            for (int actionValue : actionValues) {
                if (actionValue != 0) continue;
                return 0;
            }
        }
        if (AbstractNotifier.isAvailable() && AbstractNotifier.getNotifier().isEnabled()) {
            AbstractNotifier.getNotifier().displayBackgroundNotification(NotificationType.JOB_ERROR, title, message);
        }
        if ((userChoice = this.waitForUserResponse(dialog = this.getProgressDialog() == null ? new QuestionDialog(this.getMainFrame(), title, message, (Component)this.getMainFrame(), actionTexts, actionValues, 0) : new QuestionDialog(this.getProgressDialog(), title, message, (Component)this.getMainFrame(), actionTexts, actionValues, 0))) == -1 || userChoice == 3) {
            this.interrupt();
        } else if (userChoice == 1) {
            this.autoSkipErrors = true;
            return 0;
        }
        return userChoice;
    }

    protected int waitForUserResponse(DialogResult dialog) {
        Object userInput = this.waitForUserResponseObject(dialog);
        return (Integer)userInput;
    }

    protected Object waitForUserResponseObject(DialogResult dialog) {
        this.setPaused(true);
        UserInputHelper jobUserInput = new UserInputHelper(this, dialog);
        Object userInput = jobUserInput.getUserInput();
        this.setPaused(false);
        return userInput;
    }

    protected void refreshTables() {
        FileTable activeTable = this.getMainFrame().getActiveTable();
        FileTable inactiveTable = this.getMainFrame().getInactiveTable();
        if (this.hasFolderChanged(inactiveTable.getCurrentFolder())) {
            inactiveTable.getFolderPanel().tryRefreshCurrentFolder();
        }
        if (this.hasFolderChanged(activeTable.getCurrentFolder())) {
            if (this.fileToSelect != null && activeTable.getCurrentFolder().equalsCanonical(this.fileToSelect.getParent()) && this.fileToSelect.exists()) {
                activeTable.getFolderPanel().tryRefreshCurrentFolder(this.fileToSelect);
            } else {
                activeTable.getFolderPanel().tryRefreshCurrentFolder();
            }
        }
        this.mainFrame.getStatusBar().updateSelectedFilesInfo();
        this.getMainFrame().getLeftPanel().getFolderChangeMonitor().setPaused(false);
        this.getMainFrame().getRightPanel().getFolderChangeMonitor().setPaused(false);
    }

    public float getTotalPercentDone() {
        return (float)this.getCurrentFileIndex() / (float)this.getNbFiles();
    }

    public int getCurrentFileIndex() {
        return this.currentFileIndex == -1 ? 0 : this.currentFileIndex;
    }

    public AbstractFile getCurrentFile() {
        return this.currentFile;
    }

    private void setCurrentFile(AbstractFile file) {
        this.currentFile = file;
        this.currentFilename = "'" + file.getName() + "'";
    }

    public int getNbFiles() {
        return this.nbFiles;
    }

    protected void setNbFiles(int nbFiles) {
        this.nbFiles = nbFiles;
    }

    public String getStatusString() {
        return Translator.get("progress_dialog.processing_file", this.getCurrentFilename());
    }

    public JobProgress getJobProgress() {
        return this.jobProgress;
    }

    protected AbstractFile getBaseSourceFolder() {
        return this.baseSourceFolder;
    }

    public final void run() {
        FileTable activeTable = this.getMainFrame().getActiveTable();
        this.jobStarted();
        for (int i = 0; i < this.nbFiles; ++i) {
            AbstractFile currentFile = (AbstractFile)this.files.elementAt(i);
            this.currentFileIndex = i;
            this.nextFile(currentFile);
            boolean success = this.processFile(currentFile, null);
            if (this.getState() == 3) break;
            if (this.autoUnmark && success) {
                activeTable.setFileMarked(currentFile, false, false);
            }
            if (i != this.nbFiles - 1) continue;
            ++this.currentFileIndex;
            this.stop();
            this.jobCompleted();
            this.setState(4);
        }
        this.refreshTables();
    }

    protected abstract boolean hasFolderChanged(AbstractFile var1);

    protected abstract boolean processFile(AbstractFile var1, Object var2);
}

