/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.desktop.AbstractTrash;
import com.mucommander.desktop.DesktopManager;
import com.mucommander.job.FileJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteJob
extends FileJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteJob.class);
    private String errorDialogTitle = Translator.get("delete_dialog.error_title", new String[0]);
    private boolean moveToTrash;
    private AbstractTrash trash;
    private AbstractRWArchiveFile archiveToOptimize;
    private boolean isOptimizingArchive;

    public DeleteJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, boolean moveToTrash) {
        super(progressDialog, mainFrame, files);
        this.moveToTrash = moveToTrash;
        if (moveToTrash) {
            this.trash = DesktopManager.getTrash();
        }
    }

    private void deleteFile(AbstractFile file) throws IOException {
        if (this.moveToTrash) {
            this.trash.moveToTrash(file);
        } else {
            file.delete();
        }
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        int ret;
        if (this.getState() == 3) {
            return false;
        }
        if (!this.moveToTrash && file.isDirectory()) {
            String filePath = file.getAbsolutePath();
            filePath = filePath.substring(this.getBaseSourceFolder().getAbsolutePath(false).length() + 1, filePath.length());
            if (!file.isSymlink()) {
                while (true) {
                    try {
                        AbstractFile[] subFiles = file.ls();
                        for (int i = 0; i < subFiles.length && this.getState() != 3; ++i) {
                            this.nextFile(subFiles[i]);
                            this.processFile(subFiles[i], null);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.debug("IOException caught", e);
                        ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_read_file", filePath));
                        if (ret == 2) continue;
                        return false;
                    }
                    break;
                }
            }
        }
        if (this.getState() == 3) {
            return false;
        }
        while (true) {
            try {
                this.deleteFile(file);
                return true;
            }
            catch (IOException e) {
                LOGGER.debug("IOException caught", e);
                ret = this.showErrorDialog(this.errorDialogTitle, Translator.get(file.isDirectory() ? "cannot_delete_folder" : "cannot_delete_file", file.getName()));
                if (ret == 2) continue;
                return false;
            }
            break;
        }
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.getBaseSourceFolder().isParentOf(folder);
    }

    protected void jobStopped() {
        super.jobStopped();
        if (this.moveToTrash) {
            this.trash.waitForPendingOperations();
        }
    }

    protected void jobCompleted() {
        super.jobCompleted();
        AbstractArchiveFile archiveFile = this.getBaseSourceFolder().getParentArchive();
        if (archiveFile != null && archiveFile.isArchive() && archiveFile.isWritable()) {
            while (true) {
                try {
                    this.archiveToOptimize = (AbstractRWArchiveFile)archiveFile;
                    this.isOptimizingArchive = true;
                    this.archiveToOptimize.optimizeArchive();
                }
                catch (IOException e) {
                    if (this.showErrorDialog(this.errorDialogTitle, Translator.get("error_while_optimizing_archive", archiveFile.getName())) == 2) continue;
                }
                break;
            }
            this.isOptimizingArchive = true;
        }
    }

    public String getStatusString() {
        if (this.isOptimizingArchive) {
            return Translator.get("optimizing_archive", this.archiveToOptimize.getName());
        }
        return Translator.get("delete.deleting_file", this.getCurrentFilename());
    }
}

