/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.job;

import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.util.FileSet;
import com.mucommander.job.AbstractCopyJob;
import com.mucommander.text.Translator;
import com.mucommander.ui.dialog.file.ProgressDialog;
import com.mucommander.ui.main.MainFrame;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyJob
extends AbstractCopyJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyJob.class);
    protected AbstractFile currentDestFile;
    private int mode;

    public CopyJob(ProgressDialog progressDialog, MainFrame mainFrame, FileSet files, AbstractFile destFolder, String newName, int mode, int fileExistsAction) {
        super(progressDialog, mainFrame, files, destFolder, newName, fileExistsAction);
        this.mode = mode;
        this.errorDialogTitle = Translator.get(mode == 1 ? "download_dialog.error_title" : "copy_dialog.error_title", new String[0]);
    }

    protected boolean processFile(AbstractFile file, Object recurseParams) {
        boolean isFileInBaseFolder;
        String destFileName;
        if (this.getState() == 3) {
            return false;
        }
        AbstractFile destFolder = recurseParams == null ? this.baseDestFolder : (AbstractFile)recurseParams;
        AbstractFile destFile = this.createDestinationFile(destFolder, destFileName = (isFileInBaseFolder = this.files.indexOf(file) != -1) && this.newName != null ? this.newName : file.getName());
        if (destFile == null) {
            return false;
        }
        this.currentDestFile = destFile;
        if (file.isSymlink()) {
            return true;
        }
        if ((destFile = this.checkForCollision(file, destFolder, destFile, false)) == null) {
            return false;
        }
        if (file.isDirectory()) {
            int ret;
            if (!destFile.exists() || !destFile.isDirectory()) {
                while (true) {
                    try {
                        destFile.mkdir();
                    }
                    catch (IOException e) {
                        ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_create_folder", destFileName));
                        if (ret == 2) continue;
                        return false;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    AbstractFile[] subFiles = file.ls();
                    for (int i = 0; i < subFiles.length && this.getState() != 3; ++i) {
                        this.nextFile(subFiles[i]);
                        this.processFile(subFiles[i], destFile);
                    }
                    this.currentDestFile = destFile;
                    if (destFile.isFileOperationSupported(FileOperation.CHANGE_DATE)) {
                        try {
                            destFile.changeDate(file.getDate());
                        }
                        catch (IOException e) {
                            LOGGER.debug("failed to change the date of " + destFile, e);
                        }
                    }
                    return true;
                }
                catch (IOException e) {
                    ret = this.showErrorDialog(this.errorDialogTitle, Translator.get("cannot_read_folder", file.getName()));
                    if (ret == 2) continue;
                    return false;
                }
                break;
            }
        }
        return this.tryCopyFile(file, destFile, this.append, this.errorDialogTitle);
    }

    protected boolean hasFolderChanged(AbstractFile folder) {
        return this.baseDestFolder.isParentOf(folder);
    }

    protected void jobCompleted() {
        super.jobCompleted();
        AbstractArchiveFile archiveFile = this.baseDestFolder.getParentArchive();
        if (archiveFile != null && archiveFile.isArchive() && archiveFile.isWritable()) {
            this.optimizeArchive((AbstractRWArchiveFile)archiveFile);
        }
        if (this.files.size() == 1 && this.newName != null && this.baseDestFolder.equalsCanonical(((AbstractFile)this.files.elementAt(0)).getParent())) {
            this.selectFileWhenFinished(FileFactory.getFile(this.baseDestFolder.getAbsolutePath(true) + this.newName));
        }
    }

    public String getStatusString() {
        if (this.isCheckingIntegrity()) {
            return super.getStatusString();
        }
        if (this.isOptimizingArchive) {
            return Translator.get("optimizing_archive", this.archiveToOptimize.getName());
        }
        return Translator.get(this.mode == 1 ? "download_dialog.downloading_file" : "copy_dialog.copying_file", this.getCurrentFilename());
    }
}

